/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse;
import software.amazon.awssdk.services.devicefarm.model.UniqueProblem;

public final class ListUniqueProblemsPaginator
implements SdkIterable<ListUniqueProblemsResponse> {
    private final DeviceFarmClient client;
    private final ListUniqueProblemsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListUniqueProblemsPaginator(DeviceFarmClient client, ListUniqueProblemsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListUniqueProblemsResponseFetcher();
    }

    public Iterator<ListUniqueProblemsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Map.Entry<String, List<UniqueProblem>>> uniqueProblemsStrings() {
        Function<ListUniqueProblemsResponse, Iterator> getIterator = response -> response != null ? response.uniqueProblemsStrings().entrySet().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListUniqueProblemsResponseFetcher
    implements NextPageFetcher<ListUniqueProblemsResponse> {
        private ListUniqueProblemsResponseFetcher() {
        }

        public boolean hasNextPage(ListUniqueProblemsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListUniqueProblemsResponse nextPage(ListUniqueProblemsResponse previousPage) {
            if (previousPage == null) {
                return ListUniqueProblemsPaginator.this.client.listUniqueProblems(ListUniqueProblemsPaginator.this.firstRequest);
            }
            return ListUniqueProblemsPaginator.this.client.listUniqueProblems((ListUniqueProblemsRequest)((Object)ListUniqueProblemsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

