/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse;
import software.amazon.awssdk.services.devicefarm.model.Offering;

public final class ListOfferingsPaginator
implements SdkIterable<ListOfferingsResponse> {
    private final DeviceFarmClient client;
    private final ListOfferingsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListOfferingsPaginator(DeviceFarmClient client, ListOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOfferingsResponseFetcher();
    }

    public Iterator<ListOfferingsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Offering> offerings() {
        Function<ListOfferingsResponse, Iterator> getIterator = response -> response != null ? response.offerings().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListOfferingsResponseFetcher
    implements NextPageFetcher<ListOfferingsResponse> {
        private ListOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(ListOfferingsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListOfferingsResponse nextPage(ListOfferingsResponse previousPage) {
            if (previousPage == null) {
                return ListOfferingsPaginator.this.client.listOfferings(ListOfferingsPaginator.this.firstRequest);
            }
            return ListOfferingsPaginator.this.client.listOfferings((ListOfferingsRequest)((Object)ListOfferingsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

