/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.devicefarm.model.Sample;
import software.amazon.awssdk.services.devicefarm.model.SamplesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListSamplesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListSamplesResponse> {
    private final List<Sample> samples;
    private final String nextToken;

    private ListSamplesResponse(BuilderImpl builder) {
        this.samples = builder.samples;
        this.nextToken = builder.nextToken;
    }

    public List<Sample> samples() {
        return this.samples;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.samples());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSamplesResponse)) {
            return false;
        }
        ListSamplesResponse other = (ListSamplesResponse)((Object)obj);
        return Objects.equals(this.samples(), other.samples()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.samples() != null) {
            sb.append("Samples: ").append(this.samples()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "samples": {
                return Optional.of(clazz.cast(this.samples()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Sample> samples;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSamplesResponse model) {
            this.samples(model.samples);
            this.nextToken(model.nextToken);
        }

        public final Collection<Sample.Builder> getSamples() {
            return this.samples != null ? (Collection)this.samples.stream().map(Sample::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder samples(Collection<Sample> samples) {
            this.samples = SamplesCopier.copy(samples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samples(Sample ... samples) {
            this.samples(Arrays.asList(samples));
            return this;
        }

        public final void setSamples(Collection<Sample.BuilderImpl> samples) {
            this.samples = SamplesCopier.copyFromBuilder(samples);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListSamplesResponse build() {
            return new ListSamplesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListSamplesResponse> {
        public Builder samples(Collection<Sample> var1);

        public Builder samples(Sample ... var1);

        public Builder nextToken(String var1);
    }
}

