/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.devicefarm.model.NetworkProfile;
import software.amazon.awssdk.services.devicefarm.model.NetworkProfilesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListNetworkProfilesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListNetworkProfilesResponse> {
    private final List<NetworkProfile> networkProfiles;
    private final String nextToken;

    private ListNetworkProfilesResponse(BuilderImpl builder) {
        this.networkProfiles = builder.networkProfiles;
        this.nextToken = builder.nextToken;
    }

    public List<NetworkProfile> networkProfiles() {
        return this.networkProfiles;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkProfiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNetworkProfilesResponse)) {
            return false;
        }
        ListNetworkProfilesResponse other = (ListNetworkProfilesResponse)((Object)obj);
        return Objects.equals(this.networkProfiles(), other.networkProfiles()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.networkProfiles() != null) {
            sb.append("NetworkProfiles: ").append(this.networkProfiles()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkProfiles": {
                return Optional.of(clazz.cast(this.networkProfiles()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<NetworkProfile> networkProfiles;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNetworkProfilesResponse model) {
            this.networkProfiles(model.networkProfiles);
            this.nextToken(model.nextToken);
        }

        public final Collection<NetworkProfile.Builder> getNetworkProfiles() {
            return this.networkProfiles != null ? (Collection)this.networkProfiles.stream().map(NetworkProfile::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkProfiles(Collection<NetworkProfile> networkProfiles) {
            this.networkProfiles = NetworkProfilesCopier.copy(networkProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkProfiles(NetworkProfile ... networkProfiles) {
            this.networkProfiles(Arrays.asList(networkProfiles));
            return this;
        }

        public final void setNetworkProfiles(Collection<NetworkProfile.BuilderImpl> networkProfiles) {
            this.networkProfiles = NetworkProfilesCopier.copyFromBuilder(networkProfiles);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListNetworkProfilesResponse build() {
            return new ListNetworkProfilesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListNetworkProfilesResponse> {
        public Builder networkProfiles(Collection<NetworkProfile> var1);

        public Builder networkProfiles(NetworkProfile ... var1);

        public Builder nextToken(String var1);
    }
}

