/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.Radios;

@SdkInternalApi
public class RadiosMarshaller {
    private static final MarshallingInfo<Boolean> WIFI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("wifi").build();
    private static final MarshallingInfo<Boolean> BLUETOOTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bluetooth").build();
    private static final MarshallingInfo<Boolean> NFC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nfc").build();
    private static final MarshallingInfo<Boolean> GPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gps").build();
    private static final RadiosMarshaller INSTANCE = new RadiosMarshaller();

    public static RadiosMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Radios radios, ProtocolMarshaller protocolMarshaller) {
        if (radios == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)radios.wifi(), WIFI_BINDING);
            protocolMarshaller.marshall((Object)radios.bluetooth(), BLUETOOTH_BINDING);
            protocolMarshaller.marshall((Object)radios.nfc(), NFC_BINDING);
            protocolMarshaller.marshall((Object)radios.gps(), GPS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

