/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.TestParametersCopier;
import software.amazon.awssdk.services.devicefarm.model.TestType;
import software.amazon.awssdk.services.devicefarm.transform.ScheduleRunTestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScheduleRunTest
implements StructuredPojo,
ToCopyableBuilder<Builder, ScheduleRunTest> {
    private final String type;
    private final String testPackageArn;
    private final String filter;
    private final Map<String, String> parameters;

    private ScheduleRunTest(BuilderImpl builder) {
        this.type = builder.type;
        this.testPackageArn = builder.testPackageArn;
        this.filter = builder.filter;
        this.parameters = builder.parameters;
    }

    public TestType type() {
        return TestType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String testPackageArn() {
        return this.testPackageArn;
    }

    public String filter() {
        return this.filter;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.typeString() == null ? 0 : this.typeString().hashCode());
        hashCode = 31 * hashCode + (this.testPackageArn() == null ? 0 : this.testPackageArn().hashCode());
        hashCode = 31 * hashCode + (this.filter() == null ? 0 : this.filter().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleRunTest)) {
            return false;
        }
        ScheduleRunTest other = (ScheduleRunTest)obj;
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.testPackageArn() == null ^ this.testPackageArn() == null) {
            return false;
        }
        if (other.testPackageArn() != null && !other.testPackageArn().equals(this.testPackageArn())) {
            return false;
        }
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        if (other.filter() != null && !other.filter().equals(this.filter())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        return other.parameters() == null || other.parameters().equals(this.parameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.testPackageArn() != null) {
            sb.append("TestPackageArn: ").append(this.testPackageArn()).append(",");
        }
        if (this.filter() != null) {
            sb.append("Filter: ").append(this.filter()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "testPackageArn": {
                return Optional.of(clazz.cast(this.testPackageArn()));
            }
            case "filter": {
                return Optional.of(clazz.cast(this.filter()));
            }
            case "parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScheduleRunTestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String testPackageArn;
        private String filter;
        private Map<String, String> parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleRunTest model) {
            this.type(model.type);
            this.testPackageArn(model.testPackageArn);
            this.filter(model.filter);
            this.parameters(model.parameters);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getTestPackageArn() {
            return this.testPackageArn;
        }

        @Override
        public final Builder testPackageArn(String testPackageArn) {
            this.testPackageArn = testPackageArn;
            return this;
        }

        public final void setTestPackageArn(String testPackageArn) {
            this.testPackageArn = testPackageArn;
        }

        public final String getFilter() {
            return this.filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = TestParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = TestParametersCopier.copy(parameters);
        }

        public ScheduleRunTest build() {
            return new ScheduleRunTest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScheduleRunTest> {
        public Builder type(String var1);

        public Builder type(TestType var1);

        public Builder testPackageArn(String var1);

        public Builder filter(String var1);

        public Builder parameters(Map<String, String> var1);
    }
}

