/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.DeviceMinutesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeviceMinutes
implements StructuredPojo,
ToCopyableBuilder<Builder, DeviceMinutes> {
    private final Double total;
    private final Double metered;
    private final Double unmetered;

    private DeviceMinutes(BuilderImpl builder) {
        this.total = builder.total;
        this.metered = builder.metered;
        this.unmetered = builder.unmetered;
    }

    public Double total() {
        return this.total;
    }

    public Double metered() {
        return this.metered;
    }

    public Double unmetered() {
        return this.unmetered;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.total() == null ? 0 : this.total().hashCode());
        hashCode = 31 * hashCode + (this.metered() == null ? 0 : this.metered().hashCode());
        hashCode = 31 * hashCode + (this.unmetered() == null ? 0 : this.unmetered().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceMinutes)) {
            return false;
        }
        DeviceMinutes other = (DeviceMinutes)obj;
        if (other.total() == null ^ this.total() == null) {
            return false;
        }
        if (other.total() != null && !other.total().equals(this.total())) {
            return false;
        }
        if (other.metered() == null ^ this.metered() == null) {
            return false;
        }
        if (other.metered() != null && !other.metered().equals(this.metered())) {
            return false;
        }
        if (other.unmetered() == null ^ this.unmetered() == null) {
            return false;
        }
        return other.unmetered() == null || other.unmetered().equals(this.unmetered());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.total() != null) {
            sb.append("Total: ").append(this.total()).append(",");
        }
        if (this.metered() != null) {
            sb.append("Metered: ").append(this.metered()).append(",");
        }
        if (this.unmetered() != null) {
            sb.append("Unmetered: ").append(this.unmetered()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "total": {
                return Optional.of(clazz.cast(this.total()));
            }
            case "metered": {
                return Optional.of(clazz.cast(this.metered()));
            }
            case "unmetered": {
                return Optional.of(clazz.cast(this.unmetered()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceMinutesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Double total;
        private Double metered;
        private Double unmetered;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceMinutes model) {
            this.total(model.total);
            this.metered(model.metered);
            this.unmetered(model.unmetered);
        }

        public final Double getTotal() {
            return this.total;
        }

        @Override
        public final Builder total(Double total) {
            this.total = total;
            return this;
        }

        public final void setTotal(Double total) {
            this.total = total;
        }

        public final Double getMetered() {
            return this.metered;
        }

        @Override
        public final Builder metered(Double metered) {
            this.metered = metered;
            return this;
        }

        public final void setMetered(Double metered) {
            this.metered = metered;
        }

        public final Double getUnmetered() {
            return this.unmetered;
        }

        @Override
        public final Builder unmetered(Double unmetered) {
            this.unmetered = unmetered;
            return this;
        }

        public final void setUnmetered(Double unmetered) {
            this.unmetered = unmetered;
        }

        public DeviceMinutes build() {
            return new DeviceMinutes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeviceMinutes> {
        public Builder total(Double var1);

        public Builder metered(Double var1);

        public Builder unmetered(Double var1);
    }
}

