/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.DeviceAttribute;
import software.amazon.awssdk.services.devicefarm.model.RuleOperator;
import software.amazon.awssdk.services.devicefarm.transform.RuleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Rule
implements StructuredPojo,
ToCopyableBuilder<Builder, Rule> {
    private final String attribute;
    private final String operator;
    private final String value;

    private Rule(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.operator = builder.operator;
        this.value = builder.value;
    }

    public String attribute() {
        return this.attribute;
    }

    public String operator() {
        return this.operator;
    }

    public String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attribute() == null ? 0 : this.attribute().hashCode());
        hashCode = 31 * hashCode + (this.operator() == null ? 0 : this.operator().hashCode());
        hashCode = 31 * hashCode + (this.value() == null ? 0 : this.value().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        if (other.attribute() == null ^ this.attribute() == null) {
            return false;
        }
        if (other.attribute() != null && !other.attribute().equals(this.attribute())) {
            return false;
        }
        if (other.operator() == null ^ this.operator() == null) {
            return false;
        }
        if (other.operator() != null && !other.operator().equals(this.operator())) {
            return false;
        }
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        return other.value() == null || other.value().equals(this.value());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attribute() != null) {
            sb.append("Attribute: ").append(this.attribute()).append(",");
        }
        if (this.operator() != null) {
            sb.append("Operator: ").append(this.operator()).append(",");
        }
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String attribute;
        private String operator;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            this.setAttribute(model.attribute);
            this.setOperator(model.operator);
            this.setValue(model.value);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(DeviceAttribute attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getOperator() {
            return this.operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(RuleOperator operator) {
            this.operator(operator.toString());
            return this;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public Rule build() {
            return new Rule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Rule> {
        public Builder attribute(String var1);

        public Builder attribute(DeviceAttribute var1);

        public Builder operator(String var1);

        public Builder operator(RuleOperator var1);

        public Builder value(String var1);
    }
}

