/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.devicefarm.model.OfferingTransaction;
import software.amazon.awssdk.services.devicefarm.model.OfferingTransactionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListOfferingTransactionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListOfferingTransactionsResponse> {
    private final List<OfferingTransaction> offeringTransactions;
    private final String nextToken;

    private ListOfferingTransactionsResponse(BuilderImpl builder) {
        this.offeringTransactions = builder.offeringTransactions;
        this.nextToken = builder.nextToken;
    }

    public List<OfferingTransaction> offeringTransactions() {
        return this.offeringTransactions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.offeringTransactions() == null ? 0 : this.offeringTransactions().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOfferingTransactionsResponse)) {
            return false;
        }
        ListOfferingTransactionsResponse other = (ListOfferingTransactionsResponse)((Object)obj);
        if (other.offeringTransactions() == null ^ this.offeringTransactions() == null) {
            return false;
        }
        if (other.offeringTransactions() != null && !other.offeringTransactions().equals(this.offeringTransactions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.offeringTransactions() != null) {
            sb.append("OfferingTransactions: ").append(this.offeringTransactions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<OfferingTransaction> offeringTransactions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOfferingTransactionsResponse model) {
            this.setOfferingTransactions(model.offeringTransactions);
            this.setNextToken(model.nextToken);
        }

        public final Collection<OfferingTransaction> getOfferingTransactions() {
            return this.offeringTransactions;
        }

        @Override
        public final Builder offeringTransactions(Collection<OfferingTransaction> offeringTransactions) {
            this.offeringTransactions = OfferingTransactionsCopier.copy(offeringTransactions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringTransactions(OfferingTransaction ... offeringTransactions) {
            this.offeringTransactions(Arrays.asList(offeringTransactions));
            return this;
        }

        public final void setOfferingTransactions(Collection<OfferingTransaction> offeringTransactions) {
            this.offeringTransactions = OfferingTransactionsCopier.copy(offeringTransactions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListOfferingTransactionsResponse build() {
            return new ListOfferingTransactionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListOfferingTransactionsResponse> {
        public Builder offeringTransactions(Collection<OfferingTransaction> var1);

        public Builder offeringTransactions(OfferingTransaction ... var1);

        public Builder nextToken(String var1);
    }
}

