/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.ArtifactType;
import software.amazon.awssdk.services.devicefarm.transform.ArtifactMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Artifact
implements StructuredPojo,
ToCopyableBuilder<Builder, Artifact> {
    private final String arn;
    private final String name;
    private final String type;
    private final String extension;
    private final String url;

    private Artifact(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.extension = builder.extension;
        this.url = builder.url;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String extension() {
        return this.extension;
    }

    public String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.extension() == null ? 0 : this.extension().hashCode());
        hashCode = 31 * hashCode + (this.url() == null ? 0 : this.url().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Artifact)) {
            return false;
        }
        Artifact other = (Artifact)obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.extension() == null ^ this.extension() == null) {
            return false;
        }
        if (other.extension() != null && !other.extension().equals(this.extension())) {
            return false;
        }
        if (other.url() == null ^ this.url() == null) {
            return false;
        }
        return other.url() == null || other.url().equals(this.url());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.extension() != null) {
            sb.append("Extension: ").append(this.extension()).append(",");
        }
        if (this.url() != null) {
            sb.append("Url: ").append(this.url()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ArtifactMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String type;
        private String extension;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(Artifact model) {
            this.setArn(model.arn);
            this.setName(model.name);
            this.setType(model.type);
            this.setExtension(model.extension);
            this.setUrl(model.url);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ArtifactType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getExtension() {
            return this.extension;
        }

        @Override
        public final Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public final void setExtension(String extension) {
            this.extension = extension;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public Artifact build() {
            return new Artifact(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Artifact> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ArtifactType var1);

        public Builder extension(String var1);

        public Builder url(String var1);
    }
}

