/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.Counters;
import software.amazon.awssdk.services.devicefarm.model.DeviceMinutes;
import software.amazon.awssdk.services.devicefarm.model.ExecutionResult;
import software.amazon.awssdk.services.devicefarm.model.ExecutionStatus;
import software.amazon.awssdk.services.devicefarm.model.TestType;
import software.amazon.awssdk.services.devicefarm.transform.TestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Test
implements StructuredPojo,
ToCopyableBuilder<Builder, Test> {
    private final String arn;
    private final String name;
    private final String type;
    private final Instant created;
    private final String status;
    private final String result;
    private final Instant started;
    private final Instant stopped;
    private final Counters counters;
    private final String message;
    private final DeviceMinutes deviceMinutes;

    private Test(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.created = builder.created;
        this.status = builder.status;
        this.result = builder.result;
        this.started = builder.started;
        this.stopped = builder.stopped;
        this.counters = builder.counters;
        this.message = builder.message;
        this.deviceMinutes = builder.deviceMinutes;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public Instant created() {
        return this.created;
    }

    public String status() {
        return this.status;
    }

    public String result() {
        return this.result;
    }

    public Instant started() {
        return this.started;
    }

    public Instant stopped() {
        return this.stopped;
    }

    public Counters counters() {
        return this.counters;
    }

    public String message() {
        return this.message;
    }

    public DeviceMinutes deviceMinutes() {
        return this.deviceMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.created() == null ? 0 : this.created().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.result() == null ? 0 : this.result().hashCode());
        hashCode = 31 * hashCode + (this.started() == null ? 0 : this.started().hashCode());
        hashCode = 31 * hashCode + (this.stopped() == null ? 0 : this.stopped().hashCode());
        hashCode = 31 * hashCode + (this.counters() == null ? 0 : this.counters().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.deviceMinutes() == null ? 0 : this.deviceMinutes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Test)) {
            return false;
        }
        Test other = (Test)obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.created() == null ^ this.created() == null) {
            return false;
        }
        if (other.created() != null && !other.created().equals(this.created())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.result() == null ^ this.result() == null) {
            return false;
        }
        if (other.result() != null && !other.result().equals(this.result())) {
            return false;
        }
        if (other.started() == null ^ this.started() == null) {
            return false;
        }
        if (other.started() != null && !other.started().equals(this.started())) {
            return false;
        }
        if (other.stopped() == null ^ this.stopped() == null) {
            return false;
        }
        if (other.stopped() != null && !other.stopped().equals(this.stopped())) {
            return false;
        }
        if (other.counters() == null ^ this.counters() == null) {
            return false;
        }
        if (other.counters() != null && !other.counters().equals(this.counters())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.deviceMinutes() == null ^ this.deviceMinutes() == null) {
            return false;
        }
        return other.deviceMinutes() == null || other.deviceMinutes().equals(this.deviceMinutes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.created() != null) {
            sb.append("Created: ").append(this.created()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.result() != null) {
            sb.append("Result: ").append(this.result()).append(",");
        }
        if (this.started() != null) {
            sb.append("Started: ").append(this.started()).append(",");
        }
        if (this.stopped() != null) {
            sb.append("Stopped: ").append(this.stopped()).append(",");
        }
        if (this.counters() != null) {
            sb.append("Counters: ").append(this.counters()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.deviceMinutes() != null) {
            sb.append("DeviceMinutes: ").append(this.deviceMinutes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String type;
        private Instant created;
        private String status;
        private String result;
        private Instant started;
        private Instant stopped;
        private Counters counters;
        private String message;
        private DeviceMinutes deviceMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(Test model) {
            this.setArn(model.arn);
            this.setName(model.name);
            this.setType(model.type);
            this.setCreated(model.created);
            this.setStatus(model.status);
            this.setResult(model.result);
            this.setStarted(model.started);
            this.setStopped(model.stopped);
            this.setCounters(model.counters);
            this.setMessage(model.message);
            this.setDeviceMinutes(model.deviceMinutes);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(TestType type) {
            this.type(type.toString());
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ExecutionStatus status) {
            this.status(status.toString());
        }

        public final String getResult() {
            return this.result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result.toString());
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final void setResult(ExecutionResult result) {
            this.result(result.toString());
        }

        public final Instant getStarted() {
            return this.started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        public final Instant getStopped() {
            return this.stopped;
        }

        @Override
        public final Builder stopped(Instant stopped) {
            this.stopped = stopped;
            return this;
        }

        public final void setStopped(Instant stopped) {
            this.stopped = stopped;
        }

        public final Counters getCounters() {
            return this.counters;
        }

        @Override
        public final Builder counters(Counters counters) {
            this.counters = counters;
            return this;
        }

        public final void setCounters(Counters counters) {
            this.counters = counters;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final DeviceMinutes getDeviceMinutes() {
            return this.deviceMinutes;
        }

        @Override
        public final Builder deviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
            return this;
        }

        public final void setDeviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
        }

        public Test build() {
            return new Test(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Test> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(TestType var1);

        public Builder created(Instant var1);

        public Builder status(String var1);

        public Builder status(ExecutionStatus var1);

        public Builder result(String var1);

        public Builder result(ExecutionResult var1);

        public Builder started(Instant var1);

        public Builder stopped(Instant var1);

        public Builder counters(Counters var1);

        public Builder message(String var1);

        public Builder deviceMinutes(DeviceMinutes var1);
    }
}

