/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.devicefarm.model.DevicePoolCompatibilityResult;
import software.amazon.awssdk.services.devicefarm.model.DevicePoolCompatibilityResultsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDevicePoolCompatibilityResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetDevicePoolCompatibilityResponse> {
    private final List<DevicePoolCompatibilityResult> compatibleDevices;
    private final List<DevicePoolCompatibilityResult> incompatibleDevices;

    private GetDevicePoolCompatibilityResponse(BuilderImpl builder) {
        this.compatibleDevices = builder.compatibleDevices;
        this.incompatibleDevices = builder.incompatibleDevices;
    }

    public List<DevicePoolCompatibilityResult> compatibleDevices() {
        return this.compatibleDevices;
    }

    public List<DevicePoolCompatibilityResult> incompatibleDevices() {
        return this.incompatibleDevices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.compatibleDevices() == null ? 0 : this.compatibleDevices().hashCode());
        hashCode = 31 * hashCode + (this.incompatibleDevices() == null ? 0 : this.incompatibleDevices().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevicePoolCompatibilityResponse)) {
            return false;
        }
        GetDevicePoolCompatibilityResponse other = (GetDevicePoolCompatibilityResponse)((Object)obj);
        if (other.compatibleDevices() == null ^ this.compatibleDevices() == null) {
            return false;
        }
        if (other.compatibleDevices() != null && !other.compatibleDevices().equals(this.compatibleDevices())) {
            return false;
        }
        if (other.incompatibleDevices() == null ^ this.incompatibleDevices() == null) {
            return false;
        }
        return other.incompatibleDevices() == null || other.incompatibleDevices().equals(this.incompatibleDevices());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.compatibleDevices() != null) {
            sb.append("CompatibleDevices: ").append(this.compatibleDevices()).append(",");
        }
        if (this.incompatibleDevices() != null) {
            sb.append("IncompatibleDevices: ").append(this.incompatibleDevices()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<DevicePoolCompatibilityResult> compatibleDevices;
        private List<DevicePoolCompatibilityResult> incompatibleDevices;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevicePoolCompatibilityResponse model) {
            this.setCompatibleDevices(model.compatibleDevices);
            this.setIncompatibleDevices(model.incompatibleDevices);
        }

        public final Collection<DevicePoolCompatibilityResult> getCompatibleDevices() {
            return this.compatibleDevices;
        }

        @Override
        public final Builder compatibleDevices(Collection<DevicePoolCompatibilityResult> compatibleDevices) {
            this.compatibleDevices = DevicePoolCompatibilityResultsCopier.copy(compatibleDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleDevices(DevicePoolCompatibilityResult ... compatibleDevices) {
            this.compatibleDevices(Arrays.asList(compatibleDevices));
            return this;
        }

        public final void setCompatibleDevices(Collection<DevicePoolCompatibilityResult> compatibleDevices) {
            this.compatibleDevices = DevicePoolCompatibilityResultsCopier.copy(compatibleDevices);
        }

        @SafeVarargs
        public final void setCompatibleDevices(DevicePoolCompatibilityResult ... compatibleDevices) {
            this.compatibleDevices(Arrays.asList(compatibleDevices));
        }

        public final Collection<DevicePoolCompatibilityResult> getIncompatibleDevices() {
            return this.incompatibleDevices;
        }

        @Override
        public final Builder incompatibleDevices(Collection<DevicePoolCompatibilityResult> incompatibleDevices) {
            this.incompatibleDevices = DevicePoolCompatibilityResultsCopier.copy(incompatibleDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incompatibleDevices(DevicePoolCompatibilityResult ... incompatibleDevices) {
            this.incompatibleDevices(Arrays.asList(incompatibleDevices));
            return this;
        }

        public final void setIncompatibleDevices(Collection<DevicePoolCompatibilityResult> incompatibleDevices) {
            this.incompatibleDevices = DevicePoolCompatibilityResultsCopier.copy(incompatibleDevices);
        }

        @SafeVarargs
        public final void setIncompatibleDevices(DevicePoolCompatibilityResult ... incompatibleDevices) {
            this.incompatibleDevices(Arrays.asList(incompatibleDevices));
        }

        public GetDevicePoolCompatibilityResponse build() {
            return new GetDevicePoolCompatibilityResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetDevicePoolCompatibilityResponse> {
        public Builder compatibleDevices(Collection<DevicePoolCompatibilityResult> var1);

        public Builder compatibleDevices(DevicePoolCompatibilityResult ... var1);

        public Builder incompatibleDevices(Collection<DevicePoolCompatibilityResult> var1);

        public Builder incompatibleDevices(DevicePoolCompatibilityResult ... var1);
    }
}

