/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.CPU;
import software.amazon.awssdk.services.devicefarm.model.DeviceFormFactor;
import software.amazon.awssdk.services.devicefarm.model.DevicePlatform;
import software.amazon.awssdk.services.devicefarm.model.Resolution;
import software.amazon.awssdk.services.devicefarm.transform.DeviceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Device
implements StructuredPojo,
ToCopyableBuilder<Builder, Device> {
    private final String arn;
    private final String name;
    private final String manufacturer;
    private final String model;
    private final String formFactor;
    private final String platform;
    private final String os;
    private final CPU cpu;
    private final Resolution resolution;
    private final Long heapSize;
    private final Long memory;
    private final String image;
    private final String carrier;
    private final String radio;
    private final Boolean remoteAccessEnabled;
    private final String fleetType;
    private final String fleetName;

    private Device(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.manufacturer = builder.manufacturer;
        this.model = builder.model;
        this.formFactor = builder.formFactor;
        this.platform = builder.platform;
        this.os = builder.os;
        this.cpu = builder.cpu;
        this.resolution = builder.resolution;
        this.heapSize = builder.heapSize;
        this.memory = builder.memory;
        this.image = builder.image;
        this.carrier = builder.carrier;
        this.radio = builder.radio;
        this.remoteAccessEnabled = builder.remoteAccessEnabled;
        this.fleetType = builder.fleetType;
        this.fleetName = builder.fleetName;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String manufacturer() {
        return this.manufacturer;
    }

    public String model() {
        return this.model;
    }

    public String formFactor() {
        return this.formFactor;
    }

    public String platform() {
        return this.platform;
    }

    public String os() {
        return this.os;
    }

    public CPU cpu() {
        return this.cpu;
    }

    public Resolution resolution() {
        return this.resolution;
    }

    public Long heapSize() {
        return this.heapSize;
    }

    public Long memory() {
        return this.memory;
    }

    public String image() {
        return this.image;
    }

    public String carrier() {
        return this.carrier;
    }

    public String radio() {
        return this.radio;
    }

    public Boolean remoteAccessEnabled() {
        return this.remoteAccessEnabled;
    }

    public String fleetType() {
        return this.fleetType;
    }

    public String fleetName() {
        return this.fleetName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.manufacturer() == null ? 0 : this.manufacturer().hashCode());
        hashCode = 31 * hashCode + (this.model() == null ? 0 : this.model().hashCode());
        hashCode = 31 * hashCode + (this.formFactor() == null ? 0 : this.formFactor().hashCode());
        hashCode = 31 * hashCode + (this.platform() == null ? 0 : this.platform().hashCode());
        hashCode = 31 * hashCode + (this.os() == null ? 0 : this.os().hashCode());
        hashCode = 31 * hashCode + (this.cpu() == null ? 0 : this.cpu().hashCode());
        hashCode = 31 * hashCode + (this.resolution() == null ? 0 : this.resolution().hashCode());
        hashCode = 31 * hashCode + (this.heapSize() == null ? 0 : this.heapSize().hashCode());
        hashCode = 31 * hashCode + (this.memory() == null ? 0 : this.memory().hashCode());
        hashCode = 31 * hashCode + (this.image() == null ? 0 : this.image().hashCode());
        hashCode = 31 * hashCode + (this.carrier() == null ? 0 : this.carrier().hashCode());
        hashCode = 31 * hashCode + (this.radio() == null ? 0 : this.radio().hashCode());
        hashCode = 31 * hashCode + (this.remoteAccessEnabled() == null ? 0 : this.remoteAccessEnabled().hashCode());
        hashCode = 31 * hashCode + (this.fleetType() == null ? 0 : this.fleetType().hashCode());
        hashCode = 31 * hashCode + (this.fleetName() == null ? 0 : this.fleetName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device)obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.manufacturer() == null ^ this.manufacturer() == null) {
            return false;
        }
        if (other.manufacturer() != null && !other.manufacturer().equals(this.manufacturer())) {
            return false;
        }
        if (other.model() == null ^ this.model() == null) {
            return false;
        }
        if (other.model() != null && !other.model().equals(this.model())) {
            return false;
        }
        if (other.formFactor() == null ^ this.formFactor() == null) {
            return false;
        }
        if (other.formFactor() != null && !other.formFactor().equals(this.formFactor())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.os() == null ^ this.os() == null) {
            return false;
        }
        if (other.os() != null && !other.os().equals(this.os())) {
            return false;
        }
        if (other.cpu() == null ^ this.cpu() == null) {
            return false;
        }
        if (other.cpu() != null && !other.cpu().equals(this.cpu())) {
            return false;
        }
        if (other.resolution() == null ^ this.resolution() == null) {
            return false;
        }
        if (other.resolution() != null && !other.resolution().equals(this.resolution())) {
            return false;
        }
        if (other.heapSize() == null ^ this.heapSize() == null) {
            return false;
        }
        if (other.heapSize() != null && !other.heapSize().equals(this.heapSize())) {
            return false;
        }
        if (other.memory() == null ^ this.memory() == null) {
            return false;
        }
        if (other.memory() != null && !other.memory().equals(this.memory())) {
            return false;
        }
        if (other.image() == null ^ this.image() == null) {
            return false;
        }
        if (other.image() != null && !other.image().equals(this.image())) {
            return false;
        }
        if (other.carrier() == null ^ this.carrier() == null) {
            return false;
        }
        if (other.carrier() != null && !other.carrier().equals(this.carrier())) {
            return false;
        }
        if (other.radio() == null ^ this.radio() == null) {
            return false;
        }
        if (other.radio() != null && !other.radio().equals(this.radio())) {
            return false;
        }
        if (other.remoteAccessEnabled() == null ^ this.remoteAccessEnabled() == null) {
            return false;
        }
        if (other.remoteAccessEnabled() != null && !other.remoteAccessEnabled().equals(this.remoteAccessEnabled())) {
            return false;
        }
        if (other.fleetType() == null ^ this.fleetType() == null) {
            return false;
        }
        if (other.fleetType() != null && !other.fleetType().equals(this.fleetType())) {
            return false;
        }
        if (other.fleetName() == null ^ this.fleetName() == null) {
            return false;
        }
        return other.fleetName() == null || other.fleetName().equals(this.fleetName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.manufacturer() != null) {
            sb.append("Manufacturer: ").append(this.manufacturer()).append(",");
        }
        if (this.model() != null) {
            sb.append("Model: ").append(this.model()).append(",");
        }
        if (this.formFactor() != null) {
            sb.append("FormFactor: ").append(this.formFactor()).append(",");
        }
        if (this.platform() != null) {
            sb.append("Platform: ").append(this.platform()).append(",");
        }
        if (this.os() != null) {
            sb.append("Os: ").append(this.os()).append(",");
        }
        if (this.cpu() != null) {
            sb.append("Cpu: ").append(this.cpu()).append(",");
        }
        if (this.resolution() != null) {
            sb.append("Resolution: ").append(this.resolution()).append(",");
        }
        if (this.heapSize() != null) {
            sb.append("HeapSize: ").append(this.heapSize()).append(",");
        }
        if (this.memory() != null) {
            sb.append("Memory: ").append(this.memory()).append(",");
        }
        if (this.image() != null) {
            sb.append("Image: ").append(this.image()).append(",");
        }
        if (this.carrier() != null) {
            sb.append("Carrier: ").append(this.carrier()).append(",");
        }
        if (this.radio() != null) {
            sb.append("Radio: ").append(this.radio()).append(",");
        }
        if (this.remoteAccessEnabled() != null) {
            sb.append("RemoteAccessEnabled: ").append(this.remoteAccessEnabled()).append(",");
        }
        if (this.fleetType() != null) {
            sb.append("FleetType: ").append(this.fleetType()).append(",");
        }
        if (this.fleetName() != null) {
            sb.append("FleetName: ").append(this.fleetName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String manufacturer;
        private String model;
        private String formFactor;
        private String platform;
        private String os;
        private CPU cpu;
        private Resolution resolution;
        private Long heapSize;
        private Long memory;
        private String image;
        private String carrier;
        private String radio;
        private Boolean remoteAccessEnabled;
        private String fleetType;
        private String fleetName;

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            this.setArn(model.arn);
            this.setName(model.name);
            this.setManufacturer(model.manufacturer);
            this.setModel(model.model);
            this.setFormFactor(model.formFactor);
            this.setPlatform(model.platform);
            this.setOs(model.os);
            this.setCpu(model.cpu);
            this.setResolution(model.resolution);
            this.setHeapSize(model.heapSize);
            this.setMemory(model.memory);
            this.setImage(model.image);
            this.setCarrier(model.carrier);
            this.setRadio(model.radio);
            this.setRemoteAccessEnabled(model.remoteAccessEnabled);
            this.setFleetType(model.fleetType);
            this.setFleetName(model.fleetName);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getManufacturer() {
            return this.manufacturer;
        }

        @Override
        public final Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public final void setManufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
        }

        public final String getModel() {
            return this.model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        public final String getFormFactor() {
            return this.formFactor;
        }

        @Override
        public final Builder formFactor(String formFactor) {
            this.formFactor = formFactor;
            return this;
        }

        @Override
        public final Builder formFactor(DeviceFormFactor formFactor) {
            this.formFactor(formFactor.toString());
            return this;
        }

        public final void setFormFactor(String formFactor) {
            this.formFactor = formFactor;
        }

        public final void setFormFactor(DeviceFormFactor formFactor) {
            this.formFactor(formFactor.toString());
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(DevicePlatform platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final void setPlatform(DevicePlatform platform) {
            this.platform(platform.toString());
        }

        public final String getOs() {
            return this.os;
        }

        @Override
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        public final CPU getCpu() {
            return this.cpu;
        }

        @Override
        public final Builder cpu(CPU cpu) {
            this.cpu = cpu;
            return this;
        }

        public final void setCpu(CPU cpu) {
            this.cpu = cpu;
        }

        public final Resolution getResolution() {
            return this.resolution;
        }

        @Override
        public final Builder resolution(Resolution resolution) {
            this.resolution = resolution;
            return this;
        }

        public final void setResolution(Resolution resolution) {
            this.resolution = resolution;
        }

        public final Long getHeapSize() {
            return this.heapSize;
        }

        @Override
        public final Builder heapSize(Long heapSize) {
            this.heapSize = heapSize;
            return this;
        }

        public final void setHeapSize(Long heapSize) {
            this.heapSize = heapSize;
        }

        public final Long getMemory() {
            return this.memory;
        }

        @Override
        public final Builder memory(Long memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(Long memory) {
            this.memory = memory;
        }

        public final String getImage() {
            return this.image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final String getCarrier() {
            return this.carrier;
        }

        @Override
        public final Builder carrier(String carrier) {
            this.carrier = carrier;
            return this;
        }

        public final void setCarrier(String carrier) {
            this.carrier = carrier;
        }

        public final String getRadio() {
            return this.radio;
        }

        @Override
        public final Builder radio(String radio) {
            this.radio = radio;
            return this;
        }

        public final void setRadio(String radio) {
            this.radio = radio;
        }

        public final Boolean getRemoteAccessEnabled() {
            return this.remoteAccessEnabled;
        }

        @Override
        public final Builder remoteAccessEnabled(Boolean remoteAccessEnabled) {
            this.remoteAccessEnabled = remoteAccessEnabled;
            return this;
        }

        public final void setRemoteAccessEnabled(Boolean remoteAccessEnabled) {
            this.remoteAccessEnabled = remoteAccessEnabled;
        }

        public final String getFleetType() {
            return this.fleetType;
        }

        @Override
        public final Builder fleetType(String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        public final void setFleetType(String fleetType) {
            this.fleetType = fleetType;
        }

        public final String getFleetName() {
            return this.fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public Device build() {
            return new Device(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Device> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder manufacturer(String var1);

        public Builder model(String var1);

        public Builder formFactor(String var1);

        public Builder formFactor(DeviceFormFactor var1);

        public Builder platform(String var1);

        public Builder platform(DevicePlatform var1);

        public Builder os(String var1);

        public Builder cpu(CPU var1);

        public Builder resolution(Resolution var1);

        public Builder heapSize(Long var1);

        public Builder memory(Long var1);

        public Builder image(String var1);

        public Builder carrier(String var1);

        public Builder radio(String var1);

        public Builder remoteAccessEnabled(Boolean var1);

        public Builder fleetType(String var1);

        public Builder fleetName(String var1);
    }
}

