/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.Location;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LocationMarshaller {
    private static final MarshallingInfo<Double> LATITUDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("latitude").isBinary(false).build();
    private static final MarshallingInfo<Double> LONGITUDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("longitude").isBinary(false).build();
    private static final LocationMarshaller INSTANCE = new LocationMarshaller();

    private LocationMarshaller() {
    }

    public static LocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Location location, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)location, (String)"location");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)location.latitude(), LATITUDE_BINDING);
            protocolMarshaller.marshall((Object)location.longitude(), LONGITUDE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

