/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.DeviceInstance;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeviceInstanceMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<String> DEVICEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deviceArn").isBinary(false).build();
    private static final MarshallingInfo<List> LABELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("labels").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<String> UDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("udid").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INSTANCEPROFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceProfile").isBinary(false).build();
    private static final DeviceInstanceMarshaller INSTANCE = new DeviceInstanceMarshaller();

    private DeviceInstanceMarshaller() {
    }

    public static DeviceInstanceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeviceInstance deviceInstance, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deviceInstance, (String)"deviceInstance");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deviceInstance.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)deviceInstance.deviceArn(), DEVICEARN_BINDING);
            protocolMarshaller.marshall(deviceInstance.labels(), LABELS_BINDING);
            protocolMarshaller.marshall((Object)deviceInstance.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)deviceInstance.udid(), UDID_BINDING);
            protocolMarshaller.marshall((Object)deviceInstance.instanceProfile(), INSTANCEPROFILE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

