/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.MonetaryAmount;
import software.amazon.awssdk.services.devicefarm.model.OfferingStatus;
import software.amazon.awssdk.services.devicefarm.transform.OfferingTransactionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OfferingTransaction
implements StructuredPojo,
ToCopyableBuilder<Builder, OfferingTransaction> {
    private final OfferingStatus offeringStatus;
    private final String transactionId;
    private final String offeringPromotionId;
    private final Instant createdOn;
    private final MonetaryAmount cost;

    private OfferingTransaction(BuilderImpl builder) {
        this.offeringStatus = builder.offeringStatus;
        this.transactionId = builder.transactionId;
        this.offeringPromotionId = builder.offeringPromotionId;
        this.createdOn = builder.createdOn;
        this.cost = builder.cost;
    }

    public OfferingStatus offeringStatus() {
        return this.offeringStatus;
    }

    public String transactionId() {
        return this.transactionId;
    }

    public String offeringPromotionId() {
        return this.offeringPromotionId;
    }

    public Instant createdOn() {
        return this.createdOn;
    }

    public MonetaryAmount cost() {
        return this.cost;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringPromotionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cost());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfferingTransaction)) {
            return false;
        }
        OfferingTransaction other = (OfferingTransaction)obj;
        return Objects.equals(this.offeringStatus(), other.offeringStatus()) && Objects.equals(this.transactionId(), other.transactionId()) && Objects.equals(this.offeringPromotionId(), other.offeringPromotionId()) && Objects.equals(this.createdOn(), other.createdOn()) && Objects.equals(this.cost(), other.cost());
    }

    public String toString() {
        return ToString.builder((String)"OfferingTransaction").add("OfferingStatus", (Object)this.offeringStatus()).add("TransactionId", (Object)this.transactionId()).add("OfferingPromotionId", (Object)this.offeringPromotionId()).add("CreatedOn", (Object)this.createdOn()).add("Cost", (Object)this.cost()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "offeringStatus": {
                return Optional.ofNullable(clazz.cast(this.offeringStatus()));
            }
            case "transactionId": {
                return Optional.ofNullable(clazz.cast(this.transactionId()));
            }
            case "offeringPromotionId": {
                return Optional.ofNullable(clazz.cast(this.offeringPromotionId()));
            }
            case "createdOn": {
                return Optional.ofNullable(clazz.cast(this.createdOn()));
            }
            case "cost": {
                return Optional.ofNullable(clazz.cast(this.cost()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OfferingTransactionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private OfferingStatus offeringStatus;
        private String transactionId;
        private String offeringPromotionId;
        private Instant createdOn;
        private MonetaryAmount cost;

        private BuilderImpl() {
        }

        private BuilderImpl(OfferingTransaction model) {
            this.offeringStatus(model.offeringStatus);
            this.transactionId(model.transactionId);
            this.offeringPromotionId(model.offeringPromotionId);
            this.createdOn(model.createdOn);
            this.cost(model.cost);
        }

        public final OfferingStatus.Builder getOfferingStatus() {
            return this.offeringStatus != null ? this.offeringStatus.toBuilder() : null;
        }

        @Override
        public final Builder offeringStatus(OfferingStatus offeringStatus) {
            this.offeringStatus = offeringStatus;
            return this;
        }

        public final void setOfferingStatus(OfferingStatus.BuilderImpl offeringStatus) {
            this.offeringStatus = offeringStatus != null ? offeringStatus.build() : null;
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        public final String getOfferingPromotionId() {
            return this.offeringPromotionId;
        }

        @Override
        public final Builder offeringPromotionId(String offeringPromotionId) {
            this.offeringPromotionId = offeringPromotionId;
            return this;
        }

        public final void setOfferingPromotionId(String offeringPromotionId) {
            this.offeringPromotionId = offeringPromotionId;
        }

        public final Instant getCreatedOn() {
            return this.createdOn;
        }

        @Override
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        public final MonetaryAmount.Builder getCost() {
            return this.cost != null ? this.cost.toBuilder() : null;
        }

        @Override
        public final Builder cost(MonetaryAmount cost) {
            this.cost = cost;
            return this;
        }

        public final void setCost(MonetaryAmount.BuilderImpl cost) {
            this.cost = cost != null ? cost.build() : null;
        }

        public OfferingTransaction build() {
            return new OfferingTransaction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OfferingTransaction> {
        public Builder offeringStatus(OfferingStatus var1);

        default public Builder offeringStatus(Consumer<OfferingStatus.Builder> offeringStatus) {
            return this.offeringStatus((OfferingStatus)((OfferingStatus.Builder)OfferingStatus.builder().applyMutation(offeringStatus)).build());
        }

        public Builder transactionId(String var1);

        public Builder offeringPromotionId(String var1);

        public Builder createdOn(Instant var1);

        public Builder cost(MonetaryAmount var1);

        default public Builder cost(Consumer<MonetaryAmount.Builder> cost) {
            return this.cost((MonetaryAmount)((MonetaryAmount.Builder)MonetaryAmount.builder().applyMutation(cost)).build());
        }
    }
}

