/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.ExecutionResult;
import software.amazon.awssdk.services.devicefarm.model.UniqueProblem;
import software.amazon.awssdk.services.devicefarm.model.UniqueProblemsByExecutionResultMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUniqueProblemsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListUniqueProblemsResponse> {
    private final Map<String, List<UniqueProblem>> uniqueProblems;
    private final String nextToken;

    private ListUniqueProblemsResponse(BuilderImpl builder) {
        super(builder);
        this.uniqueProblems = builder.uniqueProblems;
        this.nextToken = builder.nextToken;
    }

    public Map<ExecutionResult, List<UniqueProblem>> uniqueProblems() {
        return TypeConverter.convert(this.uniqueProblems, ExecutionResult::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)ExecutionResult.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, List<UniqueProblem>> uniqueProblemsAsStrings() {
        return this.uniqueProblems;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uniqueProblemsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUniqueProblemsResponse)) {
            return false;
        }
        ListUniqueProblemsResponse other = (ListUniqueProblemsResponse)((Object)obj);
        return Objects.equals(this.uniqueProblemsAsStrings(), other.uniqueProblemsAsStrings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListUniqueProblemsResponse").add("UniqueProblems", this.uniqueProblemsAsStrings()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "uniqueProblems": {
                return Optional.ofNullable(clazz.cast(this.uniqueProblemsAsStrings()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private Map<String, List<UniqueProblem>> uniqueProblems = DefaultSdkAutoConstructMap.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUniqueProblemsResponse model) {
            super(model);
            this.uniqueProblemsWithStrings(model.uniqueProblems);
            this.nextToken(model.nextToken);
        }

        public final Map<String, ? extends Collection<UniqueProblem>> getUniqueProblems() {
            return this.uniqueProblems;
        }

        @Override
        public final Builder uniqueProblemsWithStrings(Map<String, ? extends Collection<UniqueProblem>> uniqueProblems) {
            this.uniqueProblems = UniqueProblemsByExecutionResultMapCopier.copy(uniqueProblems);
            return this;
        }

        @Override
        public final Builder uniqueProblems(Map<ExecutionResult, ? extends Collection<UniqueProblem>> uniqueProblems) {
            this.uniqueProblems = UniqueProblemsByExecutionResultMapCopier.copyEnumToString(uniqueProblems);
            return this;
        }

        public final void setUniqueProblems(Map<String, ? extends Collection<UniqueProblem>> uniqueProblems) {
            this.uniqueProblems = UniqueProblemsByExecutionResultMapCopier.copy(uniqueProblems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListUniqueProblemsResponse build() {
            return new ListUniqueProblemsResponse(this);
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    CopyableBuilder<Builder, ListUniqueProblemsResponse> {
        public Builder uniqueProblemsWithStrings(Map<String, ? extends Collection<UniqueProblem>> var1);

        public Builder uniqueProblems(Map<ExecutionResult, ? extends Collection<UniqueProblem>> var1);

        public Builder nextToken(String var1);
    }
}

