/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.Run;
import software.amazon.awssdk.services.devicefarm.model.RunsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRunsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListRunsResponse> {
    private final List<Run> runs;
    private final String nextToken;

    private ListRunsResponse(BuilderImpl builder) {
        super(builder);
        this.runs = builder.runs;
        this.nextToken = builder.nextToken;
    }

    public List<Run> runs() {
        return this.runs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.runs());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRunsResponse)) {
            return false;
        }
        ListRunsResponse other = (ListRunsResponse)((Object)obj);
        return Objects.equals(this.runs(), other.runs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListRunsResponse").add("Runs", this.runs()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "runs": {
                return Optional.ofNullable(clazz.cast(this.runs()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<Run> runs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRunsResponse model) {
            super(model);
            this.runs(model.runs);
            this.nextToken(model.nextToken);
        }

        public final Collection<Run.Builder> getRuns() {
            return this.runs != null ? (Collection)this.runs.stream().map(Run::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder runs(Collection<Run> runs) {
            this.runs = RunsCopier.copy(runs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runs(Run ... runs) {
            this.runs(Arrays.asList(runs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runs(Consumer<Run.Builder> ... runs) {
            this.runs(Stream.of(runs).map(c -> (Run)((Run.Builder)Run.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRuns(Collection<Run.BuilderImpl> runs) {
            this.runs = RunsCopier.copyFromBuilder(runs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRunsResponse build() {
            return new ListRunsResponse(this);
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    CopyableBuilder<Builder, ListRunsResponse> {
        public Builder runs(Collection<Run> var1);

        public Builder runs(Run ... var1);

        public Builder runs(Consumer<Run.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

