/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.InstanceProfile;
import software.amazon.awssdk.services.devicefarm.model.InstanceProfilesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInstanceProfilesResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListInstanceProfilesResponse> {
    private final List<InstanceProfile> instanceProfiles;
    private final String nextToken;

    private ListInstanceProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceProfiles = builder.instanceProfiles;
        this.nextToken = builder.nextToken;
    }

    public List<InstanceProfile> instanceProfiles() {
        return this.instanceProfiles;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceProfilesResponse)) {
            return false;
        }
        ListInstanceProfilesResponse other = (ListInstanceProfilesResponse)((Object)obj);
        return Objects.equals(this.instanceProfiles(), other.instanceProfiles()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListInstanceProfilesResponse").add("InstanceProfiles", this.instanceProfiles()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceProfiles": {
                return Optional.ofNullable(clazz.cast(this.instanceProfiles()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<InstanceProfile> instanceProfiles = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstanceProfilesResponse model) {
            super(model);
            this.instanceProfiles(model.instanceProfiles);
            this.nextToken(model.nextToken);
        }

        public final Collection<InstanceProfile.Builder> getInstanceProfiles() {
            return this.instanceProfiles != null ? (Collection)this.instanceProfiles.stream().map(InstanceProfile::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceProfiles(Collection<InstanceProfile> instanceProfiles) {
            this.instanceProfiles = InstanceProfilesCopier.copy(instanceProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfiles(InstanceProfile ... instanceProfiles) {
            this.instanceProfiles(Arrays.asList(instanceProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfiles(Consumer<InstanceProfile.Builder> ... instanceProfiles) {
            this.instanceProfiles(Stream.of(instanceProfiles).map(c -> (InstanceProfile)((InstanceProfile.Builder)InstanceProfile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceProfiles(Collection<InstanceProfile.BuilderImpl> instanceProfiles) {
            this.instanceProfiles = InstanceProfilesCopier.copyFromBuilder(instanceProfiles);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInstanceProfilesResponse build() {
            return new ListInstanceProfilesResponse(this);
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    CopyableBuilder<Builder, ListInstanceProfilesResponse> {
        public Builder instanceProfiles(Collection<InstanceProfile> var1);

        public Builder instanceProfiles(InstanceProfile ... var1);

        public Builder instanceProfiles(Consumer<InstanceProfile.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

