/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.DeviceAttribute;
import software.amazon.awssdk.services.devicefarm.transform.IncompatibilityMessageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IncompatibilityMessage
implements StructuredPojo,
ToCopyableBuilder<Builder, IncompatibilityMessage> {
    private final String message;
    private final String type;

    private IncompatibilityMessage(BuilderImpl builder) {
        this.message = builder.message;
        this.type = builder.type;
    }

    public String message() {
        return this.message;
    }

    public DeviceAttribute type() {
        return DeviceAttribute.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncompatibilityMessage)) {
            return false;
        }
        IncompatibilityMessage other = (IncompatibilityMessage)obj;
        return Objects.equals(this.message(), other.message()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"IncompatibilityMessage").add("Message", (Object)this.message()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IncompatibilityMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String message;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(IncompatibilityMessage model) {
            this.message(model.message);
            this.type(model.type);
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DeviceAttribute type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public IncompatibilityMessage build() {
            return new IncompatibilityMessage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IncompatibilityMessage> {
        public Builder message(String var1);

        public Builder type(String var1);

        public Builder type(DeviceAttribute var1);
    }
}

