/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.ExecutionConfiguration;

@SdkInternalApi
public class ExecutionConfigurationMarshaller {
    private static final MarshallingInfo<Integer> JOBTIMEOUTMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobTimeoutMinutes").build();
    private static final MarshallingInfo<Boolean> ACCOUNTSCLEANUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountsCleanup").build();
    private static final MarshallingInfo<Boolean> APPPACKAGESCLEANUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("appPackagesCleanup").build();
    private static final ExecutionConfigurationMarshaller instance = new ExecutionConfigurationMarshaller();

    public static ExecutionConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExecutionConfiguration executionConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (executionConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)executionConfiguration.jobTimeoutMinutes(), JOBTIMEOUTMINUTES_BINDING);
            protocolMarshaller.marshall((Object)executionConfiguration.accountsCleanup(), ACCOUNTSCLEANUP_BINDING);
            protocolMarshaller.marshall((Object)executionConfiguration.appPackagesCleanup(), APPPACKAGESCLEANUP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

