/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.NetworkProfileType;
import software.amazon.awssdk.services.devicefarm.transform.NetworkProfileMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NetworkProfile
implements StructuredPojo,
ToCopyableBuilder<Builder, NetworkProfile> {
    private final String arn;
    private final String name;
    private final String description;
    private final String type;
    private final Long uplinkBandwidthBits;
    private final Long downlinkBandwidthBits;
    private final Long uplinkDelayMs;
    private final Long downlinkDelayMs;
    private final Long uplinkJitterMs;
    private final Long downlinkJitterMs;
    private final Integer uplinkLossPercent;
    private final Integer downlinkLossPercent;

    private NetworkProfile(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.uplinkBandwidthBits = builder.uplinkBandwidthBits;
        this.downlinkBandwidthBits = builder.downlinkBandwidthBits;
        this.uplinkDelayMs = builder.uplinkDelayMs;
        this.downlinkDelayMs = builder.downlinkDelayMs;
        this.uplinkJitterMs = builder.uplinkJitterMs;
        this.downlinkJitterMs = builder.downlinkJitterMs;
        this.uplinkLossPercent = builder.uplinkLossPercent;
        this.downlinkLossPercent = builder.downlinkLossPercent;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String type() {
        return this.type;
    }

    public Long uplinkBandwidthBits() {
        return this.uplinkBandwidthBits;
    }

    public Long downlinkBandwidthBits() {
        return this.downlinkBandwidthBits;
    }

    public Long uplinkDelayMs() {
        return this.uplinkDelayMs;
    }

    public Long downlinkDelayMs() {
        return this.downlinkDelayMs;
    }

    public Long uplinkJitterMs() {
        return this.uplinkJitterMs;
    }

    public Long downlinkJitterMs() {
        return this.downlinkJitterMs;
    }

    public Integer uplinkLossPercent() {
        return this.uplinkLossPercent;
    }

    public Integer downlinkLossPercent() {
        return this.downlinkLossPercent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.uplinkBandwidthBits() == null ? 0 : this.uplinkBandwidthBits().hashCode());
        hashCode = 31 * hashCode + (this.downlinkBandwidthBits() == null ? 0 : this.downlinkBandwidthBits().hashCode());
        hashCode = 31 * hashCode + (this.uplinkDelayMs() == null ? 0 : this.uplinkDelayMs().hashCode());
        hashCode = 31 * hashCode + (this.downlinkDelayMs() == null ? 0 : this.downlinkDelayMs().hashCode());
        hashCode = 31 * hashCode + (this.uplinkJitterMs() == null ? 0 : this.uplinkJitterMs().hashCode());
        hashCode = 31 * hashCode + (this.downlinkJitterMs() == null ? 0 : this.downlinkJitterMs().hashCode());
        hashCode = 31 * hashCode + (this.uplinkLossPercent() == null ? 0 : this.uplinkLossPercent().hashCode());
        hashCode = 31 * hashCode + (this.downlinkLossPercent() == null ? 0 : this.downlinkLossPercent().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkProfile)) {
            return false;
        }
        NetworkProfile other = (NetworkProfile)obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.uplinkBandwidthBits() == null ^ this.uplinkBandwidthBits() == null) {
            return false;
        }
        if (other.uplinkBandwidthBits() != null && !other.uplinkBandwidthBits().equals(this.uplinkBandwidthBits())) {
            return false;
        }
        if (other.downlinkBandwidthBits() == null ^ this.downlinkBandwidthBits() == null) {
            return false;
        }
        if (other.downlinkBandwidthBits() != null && !other.downlinkBandwidthBits().equals(this.downlinkBandwidthBits())) {
            return false;
        }
        if (other.uplinkDelayMs() == null ^ this.uplinkDelayMs() == null) {
            return false;
        }
        if (other.uplinkDelayMs() != null && !other.uplinkDelayMs().equals(this.uplinkDelayMs())) {
            return false;
        }
        if (other.downlinkDelayMs() == null ^ this.downlinkDelayMs() == null) {
            return false;
        }
        if (other.downlinkDelayMs() != null && !other.downlinkDelayMs().equals(this.downlinkDelayMs())) {
            return false;
        }
        if (other.uplinkJitterMs() == null ^ this.uplinkJitterMs() == null) {
            return false;
        }
        if (other.uplinkJitterMs() != null && !other.uplinkJitterMs().equals(this.uplinkJitterMs())) {
            return false;
        }
        if (other.downlinkJitterMs() == null ^ this.downlinkJitterMs() == null) {
            return false;
        }
        if (other.downlinkJitterMs() != null && !other.downlinkJitterMs().equals(this.downlinkJitterMs())) {
            return false;
        }
        if (other.uplinkLossPercent() == null ^ this.uplinkLossPercent() == null) {
            return false;
        }
        if (other.uplinkLossPercent() != null && !other.uplinkLossPercent().equals(this.uplinkLossPercent())) {
            return false;
        }
        if (other.downlinkLossPercent() == null ^ this.downlinkLossPercent() == null) {
            return false;
        }
        return other.downlinkLossPercent() == null || other.downlinkLossPercent().equals(this.downlinkLossPercent());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.uplinkBandwidthBits() != null) {
            sb.append("UplinkBandwidthBits: ").append(this.uplinkBandwidthBits()).append(",");
        }
        if (this.downlinkBandwidthBits() != null) {
            sb.append("DownlinkBandwidthBits: ").append(this.downlinkBandwidthBits()).append(",");
        }
        if (this.uplinkDelayMs() != null) {
            sb.append("UplinkDelayMs: ").append(this.uplinkDelayMs()).append(",");
        }
        if (this.downlinkDelayMs() != null) {
            sb.append("DownlinkDelayMs: ").append(this.downlinkDelayMs()).append(",");
        }
        if (this.uplinkJitterMs() != null) {
            sb.append("UplinkJitterMs: ").append(this.uplinkJitterMs()).append(",");
        }
        if (this.downlinkJitterMs() != null) {
            sb.append("DownlinkJitterMs: ").append(this.downlinkJitterMs()).append(",");
        }
        if (this.uplinkLossPercent() != null) {
            sb.append("UplinkLossPercent: ").append(this.uplinkLossPercent()).append(",");
        }
        if (this.downlinkLossPercent() != null) {
            sb.append("DownlinkLossPercent: ").append(this.downlinkLossPercent()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NetworkProfileMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private String type;
        private Long uplinkBandwidthBits;
        private Long downlinkBandwidthBits;
        private Long uplinkDelayMs;
        private Long downlinkDelayMs;
        private Long uplinkJitterMs;
        private Long downlinkJitterMs;
        private Integer uplinkLossPercent;
        private Integer downlinkLossPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkProfile model) {
            this.setArn(model.arn);
            this.setName(model.name);
            this.setDescription(model.description);
            this.setType(model.type);
            this.setUplinkBandwidthBits(model.uplinkBandwidthBits);
            this.setDownlinkBandwidthBits(model.downlinkBandwidthBits);
            this.setUplinkDelayMs(model.uplinkDelayMs);
            this.setDownlinkDelayMs(model.downlinkDelayMs);
            this.setUplinkJitterMs(model.uplinkJitterMs);
            this.setDownlinkJitterMs(model.downlinkJitterMs);
            this.setUplinkLossPercent(model.uplinkLossPercent);
            this.setDownlinkLossPercent(model.downlinkLossPercent);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NetworkProfileType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(NetworkProfileType type) {
            this.type(type.toString());
        }

        public final Long getUplinkBandwidthBits() {
            return this.uplinkBandwidthBits;
        }

        @Override
        public final Builder uplinkBandwidthBits(Long uplinkBandwidthBits) {
            this.uplinkBandwidthBits = uplinkBandwidthBits;
            return this;
        }

        public final void setUplinkBandwidthBits(Long uplinkBandwidthBits) {
            this.uplinkBandwidthBits = uplinkBandwidthBits;
        }

        public final Long getDownlinkBandwidthBits() {
            return this.downlinkBandwidthBits;
        }

        @Override
        public final Builder downlinkBandwidthBits(Long downlinkBandwidthBits) {
            this.downlinkBandwidthBits = downlinkBandwidthBits;
            return this;
        }

        public final void setDownlinkBandwidthBits(Long downlinkBandwidthBits) {
            this.downlinkBandwidthBits = downlinkBandwidthBits;
        }

        public final Long getUplinkDelayMs() {
            return this.uplinkDelayMs;
        }

        @Override
        public final Builder uplinkDelayMs(Long uplinkDelayMs) {
            this.uplinkDelayMs = uplinkDelayMs;
            return this;
        }

        public final void setUplinkDelayMs(Long uplinkDelayMs) {
            this.uplinkDelayMs = uplinkDelayMs;
        }

        public final Long getDownlinkDelayMs() {
            return this.downlinkDelayMs;
        }

        @Override
        public final Builder downlinkDelayMs(Long downlinkDelayMs) {
            this.downlinkDelayMs = downlinkDelayMs;
            return this;
        }

        public final void setDownlinkDelayMs(Long downlinkDelayMs) {
            this.downlinkDelayMs = downlinkDelayMs;
        }

        public final Long getUplinkJitterMs() {
            return this.uplinkJitterMs;
        }

        @Override
        public final Builder uplinkJitterMs(Long uplinkJitterMs) {
            this.uplinkJitterMs = uplinkJitterMs;
            return this;
        }

        public final void setUplinkJitterMs(Long uplinkJitterMs) {
            this.uplinkJitterMs = uplinkJitterMs;
        }

        public final Long getDownlinkJitterMs() {
            return this.downlinkJitterMs;
        }

        @Override
        public final Builder downlinkJitterMs(Long downlinkJitterMs) {
            this.downlinkJitterMs = downlinkJitterMs;
            return this;
        }

        public final void setDownlinkJitterMs(Long downlinkJitterMs) {
            this.downlinkJitterMs = downlinkJitterMs;
        }

        public final Integer getUplinkLossPercent() {
            return this.uplinkLossPercent;
        }

        @Override
        public final Builder uplinkLossPercent(Integer uplinkLossPercent) {
            this.uplinkLossPercent = uplinkLossPercent;
            return this;
        }

        public final void setUplinkLossPercent(Integer uplinkLossPercent) {
            this.uplinkLossPercent = uplinkLossPercent;
        }

        public final Integer getDownlinkLossPercent() {
            return this.downlinkLossPercent;
        }

        @Override
        public final Builder downlinkLossPercent(Integer downlinkLossPercent) {
            this.downlinkLossPercent = downlinkLossPercent;
            return this;
        }

        public final void setDownlinkLossPercent(Integer downlinkLossPercent) {
            this.downlinkLossPercent = downlinkLossPercent;
        }

        public NetworkProfile build() {
            return new NetworkProfile(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NetworkProfile> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(NetworkProfileType var1);

        public Builder uplinkBandwidthBits(Long var1);

        public Builder downlinkBandwidthBits(Long var1);

        public Builder uplinkDelayMs(Long var1);

        public Builder downlinkDelayMs(Long var1);

        public Builder uplinkJitterMs(Long var1);

        public Builder downlinkJitterMs(Long var1);

        public Builder uplinkLossPercent(Integer var1);

        public Builder downlinkLossPercent(Integer var1);
    }
}

