/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.LocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Location
implements StructuredPojo,
ToCopyableBuilder<Builder, Location> {
    private final Double latitude;
    private final Double longitude;

    private Location(BuilderImpl builder) {
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
    }

    public Double latitude() {
        return this.latitude;
    }

    public Double longitude() {
        return this.longitude;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.latitude() == null ? 0 : this.latitude().hashCode());
        hashCode = 31 * hashCode + (this.longitude() == null ? 0 : this.longitude().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        if (other.latitude() == null ^ this.latitude() == null) {
            return false;
        }
        if (other.latitude() != null && !other.latitude().equals(this.latitude())) {
            return false;
        }
        if (other.longitude() == null ^ this.longitude() == null) {
            return false;
        }
        return other.longitude() == null || other.longitude().equals(this.longitude());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.latitude() != null) {
            sb.append("Latitude: ").append(this.latitude()).append(",");
        }
        if (this.longitude() != null) {
            sb.append("Longitude: ").append(this.longitude()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Double latitude;
        private Double longitude;

        private BuilderImpl() {
        }

        private BuilderImpl(Location model) {
            this.setLatitude(model.latitude);
            this.setLongitude(model.longitude);
        }

        public final Double getLatitude() {
            return this.latitude;
        }

        @Override
        public final Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public final void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        public final Double getLongitude() {
            return this.longitude;
        }

        @Override
        public final Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        public final void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        public Location build() {
            return new Location(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Location> {
        public Builder latitude(Double var1);

        public Builder longitude(Double var1);
    }
}

