/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.devicefarm.model.NetworkProfile;
import software.amazon.awssdk.services.devicefarm.model.NetworkProfilesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListNetworkProfilesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListNetworkProfilesResponse> {
    private final List<NetworkProfile> networkProfiles;
    private final String nextToken;

    private ListNetworkProfilesResponse(BuilderImpl builder) {
        this.networkProfiles = builder.networkProfiles;
        this.nextToken = builder.nextToken;
    }

    public List<NetworkProfile> networkProfiles() {
        return this.networkProfiles;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.networkProfiles() == null ? 0 : this.networkProfiles().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNetworkProfilesResponse)) {
            return false;
        }
        ListNetworkProfilesResponse other = (ListNetworkProfilesResponse)((Object)obj);
        if (other.networkProfiles() == null ^ this.networkProfiles() == null) {
            return false;
        }
        if (other.networkProfiles() != null && !other.networkProfiles().equals(this.networkProfiles())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.networkProfiles() != null) {
            sb.append("NetworkProfiles: ").append(this.networkProfiles()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<NetworkProfile> networkProfiles;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNetworkProfilesResponse model) {
            this.setNetworkProfiles(model.networkProfiles);
            this.setNextToken(model.nextToken);
        }

        public final Collection<NetworkProfile> getNetworkProfiles() {
            return this.networkProfiles;
        }

        @Override
        public final Builder networkProfiles(Collection<NetworkProfile> networkProfiles) {
            this.networkProfiles = NetworkProfilesCopier.copy(networkProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkProfiles(NetworkProfile ... networkProfiles) {
            if (this.networkProfiles == null) {
                this.networkProfiles = new ArrayList<NetworkProfile>(networkProfiles.length);
            }
            for (NetworkProfile e : networkProfiles) {
                this.networkProfiles.add(e);
            }
            return this;
        }

        public final void setNetworkProfiles(Collection<NetworkProfile> networkProfiles) {
            this.networkProfiles = NetworkProfilesCopier.copy(networkProfiles);
        }

        @SafeVarargs
        public final void setNetworkProfiles(NetworkProfile ... networkProfiles) {
            if (this.networkProfiles == null) {
                this.networkProfiles = new ArrayList<NetworkProfile>(networkProfiles.length);
            }
            for (NetworkProfile e : networkProfiles) {
                this.networkProfiles.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListNetworkProfilesResponse build() {
            return new ListNetworkProfilesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListNetworkProfilesResponse> {
        public Builder networkProfiles(Collection<NetworkProfile> var1);

        public Builder networkProfiles(NetworkProfile ... var1);

        public Builder nextToken(String var1);
    }
}

