/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.transform.CPUMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CPU
implements StructuredPojo,
ToCopyableBuilder<Builder, CPU> {
    private final String frequency;
    private final String architecture;
    private final Double clock;

    private CPU(BuilderImpl builder) {
        this.frequency = builder.frequency;
        this.architecture = builder.architecture;
        this.clock = builder.clock;
    }

    public String frequency() {
        return this.frequency;
    }

    public String architecture() {
        return this.architecture;
    }

    public Double clock() {
        return this.clock;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.frequency() == null ? 0 : this.frequency().hashCode());
        hashCode = 31 * hashCode + (this.architecture() == null ? 0 : this.architecture().hashCode());
        hashCode = 31 * hashCode + (this.clock() == null ? 0 : this.clock().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CPU)) {
            return false;
        }
        CPU other = (CPU)obj;
        if (other.frequency() == null ^ this.frequency() == null) {
            return false;
        }
        if (other.frequency() != null && !other.frequency().equals(this.frequency())) {
            return false;
        }
        if (other.architecture() == null ^ this.architecture() == null) {
            return false;
        }
        if (other.architecture() != null && !other.architecture().equals(this.architecture())) {
            return false;
        }
        if (other.clock() == null ^ this.clock() == null) {
            return false;
        }
        return other.clock() == null || other.clock().equals(this.clock());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.frequency() != null) {
            sb.append("Frequency: ").append(this.frequency()).append(",");
        }
        if (this.architecture() != null) {
            sb.append("Architecture: ").append(this.architecture()).append(",");
        }
        if (this.clock() != null) {
            sb.append("Clock: ").append(this.clock()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CPUMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String frequency;
        private String architecture;
        private Double clock;

        private BuilderImpl() {
        }

        private BuilderImpl(CPU model) {
            this.setFrequency(model.frequency);
            this.setArchitecture(model.architecture);
            this.setClock(model.clock);
        }

        public final String getFrequency() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final Double getClock() {
            return this.clock;
        }

        @Override
        public final Builder clock(Double clock) {
            this.clock = clock;
            return this;
        }

        public final void setClock(Double clock) {
            this.clock = clock;
        }

        public CPU build() {
            return new CPU(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CPU> {
        public Builder frequency(String var1);

        public Builder architecture(String var1);

        public Builder clock(Double var1);
    }
}

