/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.detective.model.DatasourcePackageIngestState;
import software.amazon.awssdk.services.detective.model.LastIngestStateChangeDatesCopier;
import software.amazon.awssdk.services.detective.model.TimestampForCollection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasourcePackageIngestDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasourcePackageIngestDetail> {
    private static final SdkField<String> DATASOURCE_PACKAGE_INGEST_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasourcePackageIngestState").getter(DatasourcePackageIngestDetail.getter(DatasourcePackageIngestDetail::datasourcePackageIngestStateAsString)).setter(DatasourcePackageIngestDetail.setter(Builder::datasourcePackageIngestState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasourcePackageIngestState").build()}).build();
    private static final SdkField<Map<String, TimestampForCollection>> LAST_INGEST_STATE_CHANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("LastIngestStateChange").getter(DatasourcePackageIngestDetail.getter(DatasourcePackageIngestDetail::lastIngestStateChangeAsStrings)).setter(DatasourcePackageIngestDetail.setter(Builder::lastIngestStateChangeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastIngestStateChange").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimestampForCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASOURCE_PACKAGE_INGEST_STATE_FIELD, LAST_INGEST_STATE_CHANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DatasourcePackageIngestState", DATASOURCE_PACKAGE_INGEST_STATE_FIELD);
            this.put("LastIngestStateChange", LAST_INGEST_STATE_CHANGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String datasourcePackageIngestState;
    private final Map<String, TimestampForCollection> lastIngestStateChange;

    private DatasourcePackageIngestDetail(BuilderImpl builder) {
        this.datasourcePackageIngestState = builder.datasourcePackageIngestState;
        this.lastIngestStateChange = builder.lastIngestStateChange;
    }

    public final DatasourcePackageIngestState datasourcePackageIngestState() {
        return DatasourcePackageIngestState.fromValue(this.datasourcePackageIngestState);
    }

    public final String datasourcePackageIngestStateAsString() {
        return this.datasourcePackageIngestState;
    }

    public final Map<DatasourcePackageIngestState, TimestampForCollection> lastIngestStateChange() {
        return LastIngestStateChangeDatesCopier.copyStringToEnum(this.lastIngestStateChange);
    }

    public final boolean hasLastIngestStateChange() {
        return this.lastIngestStateChange != null && !(this.lastIngestStateChange instanceof SdkAutoConstructMap);
    }

    public final Map<String, TimestampForCollection> lastIngestStateChangeAsStrings() {
        return this.lastIngestStateChange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datasourcePackageIngestStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLastIngestStateChange() ? this.lastIngestStateChangeAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasourcePackageIngestDetail)) {
            return false;
        }
        DatasourcePackageIngestDetail other = (DatasourcePackageIngestDetail)obj;
        return Objects.equals(this.datasourcePackageIngestStateAsString(), other.datasourcePackageIngestStateAsString()) && this.hasLastIngestStateChange() == other.hasLastIngestStateChange() && Objects.equals(this.lastIngestStateChangeAsStrings(), other.lastIngestStateChangeAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"DatasourcePackageIngestDetail").add("DatasourcePackageIngestState", (Object)this.datasourcePackageIngestStateAsString()).add("LastIngestStateChange", this.hasLastIngestStateChange() ? this.lastIngestStateChangeAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasourcePackageIngestState": {
                return Optional.ofNullable(clazz.cast(this.datasourcePackageIngestStateAsString()));
            }
            case "LastIngestStateChange": {
                return Optional.ofNullable(clazz.cast(this.lastIngestStateChangeAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DatasourcePackageIngestDetail, T> g) {
        return obj -> g.apply((DatasourcePackageIngestDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String datasourcePackageIngestState;
        private Map<String, TimestampForCollection> lastIngestStateChange = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DatasourcePackageIngestDetail model) {
            this.datasourcePackageIngestState(model.datasourcePackageIngestState);
            this.lastIngestStateChangeWithStrings(model.lastIngestStateChange);
        }

        public final String getDatasourcePackageIngestState() {
            return this.datasourcePackageIngestState;
        }

        public final void setDatasourcePackageIngestState(String datasourcePackageIngestState) {
            this.datasourcePackageIngestState = datasourcePackageIngestState;
        }

        @Override
        public final Builder datasourcePackageIngestState(String datasourcePackageIngestState) {
            this.datasourcePackageIngestState = datasourcePackageIngestState;
            return this;
        }

        @Override
        public final Builder datasourcePackageIngestState(DatasourcePackageIngestState datasourcePackageIngestState) {
            this.datasourcePackageIngestState(datasourcePackageIngestState == null ? null : datasourcePackageIngestState.toString());
            return this;
        }

        public final Map<String, TimestampForCollection.Builder> getLastIngestStateChange() {
            Map<String, TimestampForCollection.Builder> result = LastIngestStateChangeDatesCopier.copyToBuilder(this.lastIngestStateChange);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setLastIngestStateChange(Map<String, TimestampForCollection.BuilderImpl> lastIngestStateChange) {
            this.lastIngestStateChange = LastIngestStateChangeDatesCopier.copyFromBuilder(lastIngestStateChange);
        }

        @Override
        public final Builder lastIngestStateChangeWithStrings(Map<String, TimestampForCollection> lastIngestStateChange) {
            this.lastIngestStateChange = LastIngestStateChangeDatesCopier.copy(lastIngestStateChange);
            return this;
        }

        @Override
        public final Builder lastIngestStateChange(Map<DatasourcePackageIngestState, TimestampForCollection> lastIngestStateChange) {
            this.lastIngestStateChange = LastIngestStateChangeDatesCopier.copyEnumToString(lastIngestStateChange);
            return this;
        }

        public DatasourcePackageIngestDetail build() {
            return new DatasourcePackageIngestDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasourcePackageIngestDetail> {
        public Builder datasourcePackageIngestState(String var1);

        public Builder datasourcePackageIngestState(DatasourcePackageIngestState var1);

        public Builder lastIngestStateChangeWithStrings(Map<String, TimestampForCollection> var1);

        public Builder lastIngestStateChange(Map<DatasourcePackageIngestState, TimestampForCollection> var1);
    }
}

