/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.detective.DetectiveAsyncClient;
import software.amazon.awssdk.services.detective.internal.UserAgentUtils;
import software.amazon.awssdk.services.detective.model.ListDatasourcePackagesRequest;
import software.amazon.awssdk.services.detective.model.ListDatasourcePackagesResponse;

public class ListDatasourcePackagesPublisher
implements SdkPublisher<ListDatasourcePackagesResponse> {
    private final DetectiveAsyncClient client;
    private final ListDatasourcePackagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDatasourcePackagesPublisher(DetectiveAsyncClient client, ListDatasourcePackagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDatasourcePackagesPublisher(DetectiveAsyncClient client, ListDatasourcePackagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDatasourcePackagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDatasourcePackagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDatasourcePackagesResponseFetcher
    implements AsyncPageFetcher<ListDatasourcePackagesResponse> {
        private ListDatasourcePackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasourcePackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDatasourcePackagesResponse> nextPage(ListDatasourcePackagesResponse previousPage) {
            if (previousPage == null) {
                return ListDatasourcePackagesPublisher.this.client.listDatasourcePackages(ListDatasourcePackagesPublisher.this.firstRequest);
            }
            return ListDatasourcePackagesPublisher.this.client.listDatasourcePackages((ListDatasourcePackagesRequest)((Object)ListDatasourcePackagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

