/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DatasourcePackageIngestState {
    STARTED("STARTED"),
    STOPPED("STOPPED"),
    DISABLED("DISABLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DatasourcePackageIngestState> VALUE_MAP;
    private final String value;

    private DatasourcePackageIngestState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DatasourcePackageIngestState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DatasourcePackageIngestState> knownValues() {
        EnumSet<DatasourcePackageIngestState> knownValues = EnumSet.allOf(DatasourcePackageIngestState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DatasourcePackageIngestState.class, DatasourcePackageIngestState::toString);
    }
}

