/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.detective.model.InvitationType;
import software.amazon.awssdk.services.detective.model.MemberDisabledReason;
import software.amazon.awssdk.services.detective.model.MemberStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MemberDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MemberDetail> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(MemberDetail.getter(MemberDetail::accountId)).setter(MemberDetail.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailAddress").getter(MemberDetail.getter(MemberDetail::emailAddress)).setter(MemberDetail.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()}).build();
    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GraphArn").getter(MemberDetail.getter(MemberDetail::graphArn)).setter(MemberDetail.setter(Builder::graphArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()}).build();
    private static final SdkField<String> MASTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterId").getter(MemberDetail.getter(MemberDetail::masterId)).setter(MemberDetail.setter(Builder::masterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterId").build()}).build();
    private static final SdkField<String> ADMINISTRATOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdministratorId").getter(MemberDetail.getter(MemberDetail::administratorId)).setter(MemberDetail.setter(Builder::administratorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministratorId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(MemberDetail.getter(MemberDetail::statusAsString)).setter(MemberDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> DISABLED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisabledReason").getter(MemberDetail.getter(MemberDetail::disabledReasonAsString)).setter(MemberDetail.setter(Builder::disabledReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledReason").build()}).build();
    private static final SdkField<Instant> INVITED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InvitedTime").getter(MemberDetail.getter(MemberDetail::invitedTime)).setter(MemberDetail.setter(Builder::invitedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTime").getter(MemberDetail.getter(MemberDetail::updatedTime)).setter(MemberDetail.setter(Builder::updatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Long> VOLUME_USAGE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VolumeUsageInBytes").getter(MemberDetail.getter(MemberDetail::volumeUsageInBytes)).setter(MemberDetail.setter(Builder::volumeUsageInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeUsageInBytes").build()}).build();
    private static final SdkField<Instant> VOLUME_USAGE_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("VolumeUsageUpdatedTime").getter(MemberDetail.getter(MemberDetail::volumeUsageUpdatedTime)).setter(MemberDetail.setter(Builder::volumeUsageUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeUsageUpdatedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Double> PERCENT_OF_GRAPH_UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("PercentOfGraphUtilization").getter(MemberDetail.getter(MemberDetail::percentOfGraphUtilization)).setter(MemberDetail.setter(Builder::percentOfGraphUtilization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentOfGraphUtilization").build()}).build();
    private static final SdkField<Instant> PERCENT_OF_GRAPH_UTILIZATION_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PercentOfGraphUtilizationUpdatedTime").getter(MemberDetail.getter(MemberDetail::percentOfGraphUtilizationUpdatedTime)).setter(MemberDetail.setter(Builder::percentOfGraphUtilizationUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentOfGraphUtilizationUpdatedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> INVITATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvitationType").getter(MemberDetail.getter(MemberDetail::invitationTypeAsString)).setter(MemberDetail.setter(Builder::invitationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, EMAIL_ADDRESS_FIELD, GRAPH_ARN_FIELD, MASTER_ID_FIELD, ADMINISTRATOR_ID_FIELD, STATUS_FIELD, DISABLED_REASON_FIELD, INVITED_TIME_FIELD, UPDATED_TIME_FIELD, VOLUME_USAGE_IN_BYTES_FIELD, VOLUME_USAGE_UPDATED_TIME_FIELD, PERCENT_OF_GRAPH_UTILIZATION_FIELD, PERCENT_OF_GRAPH_UTILIZATION_UPDATED_TIME_FIELD, INVITATION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String emailAddress;
    private final String graphArn;
    private final String masterId;
    private final String administratorId;
    private final String status;
    private final String disabledReason;
    private final Instant invitedTime;
    private final Instant updatedTime;
    private final Long volumeUsageInBytes;
    private final Instant volumeUsageUpdatedTime;
    private final Double percentOfGraphUtilization;
    private final Instant percentOfGraphUtilizationUpdatedTime;
    private final String invitationType;

    private MemberDetail(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.emailAddress = builder.emailAddress;
        this.graphArn = builder.graphArn;
        this.masterId = builder.masterId;
        this.administratorId = builder.administratorId;
        this.status = builder.status;
        this.disabledReason = builder.disabledReason;
        this.invitedTime = builder.invitedTime;
        this.updatedTime = builder.updatedTime;
        this.volumeUsageInBytes = builder.volumeUsageInBytes;
        this.volumeUsageUpdatedTime = builder.volumeUsageUpdatedTime;
        this.percentOfGraphUtilization = builder.percentOfGraphUtilization;
        this.percentOfGraphUtilizationUpdatedTime = builder.percentOfGraphUtilizationUpdatedTime;
        this.invitationType = builder.invitationType;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String emailAddress() {
        return this.emailAddress;
    }

    public final String graphArn() {
        return this.graphArn;
    }

    @Deprecated
    public final String masterId() {
        return this.masterId;
    }

    public final String administratorId() {
        return this.administratorId;
    }

    public final MemberStatus status() {
        return MemberStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final MemberDisabledReason disabledReason() {
        return MemberDisabledReason.fromValue(this.disabledReason);
    }

    public final String disabledReasonAsString() {
        return this.disabledReason;
    }

    public final Instant invitedTime() {
        return this.invitedTime;
    }

    public final Instant updatedTime() {
        return this.updatedTime;
    }

    public final Long volumeUsageInBytes() {
        return this.volumeUsageInBytes;
    }

    public final Instant volumeUsageUpdatedTime() {
        return this.volumeUsageUpdatedTime;
    }

    @Deprecated
    public final Double percentOfGraphUtilization() {
        return this.percentOfGraphUtilization;
    }

    @Deprecated
    public final Instant percentOfGraphUtilizationUpdatedTime() {
        return this.percentOfGraphUtilizationUpdatedTime;
    }

    public final InvitationType invitationType() {
        return InvitationType.fromValue(this.invitationType);
    }

    public final String invitationTypeAsString() {
        return this.invitationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.administratorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabledReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.invitedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeUsageInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeUsageUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentOfGraphUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentOfGraphUtilizationUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.invitationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberDetail)) {
            return false;
        }
        MemberDetail other = (MemberDetail)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.graphArn(), other.graphArn()) && Objects.equals(this.masterId(), other.masterId()) && Objects.equals(this.administratorId(), other.administratorId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.disabledReasonAsString(), other.disabledReasonAsString()) && Objects.equals(this.invitedTime(), other.invitedTime()) && Objects.equals(this.updatedTime(), other.updatedTime()) && Objects.equals(this.volumeUsageInBytes(), other.volumeUsageInBytes()) && Objects.equals(this.volumeUsageUpdatedTime(), other.volumeUsageUpdatedTime()) && Objects.equals(this.percentOfGraphUtilization(), other.percentOfGraphUtilization()) && Objects.equals(this.percentOfGraphUtilizationUpdatedTime(), other.percentOfGraphUtilizationUpdatedTime()) && Objects.equals(this.invitationTypeAsString(), other.invitationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MemberDetail").add("AccountId", (Object)this.accountId()).add("EmailAddress", (Object)this.emailAddress()).add("GraphArn", (Object)this.graphArn()).add("MasterId", (Object)this.masterId()).add("AdministratorId", (Object)this.administratorId()).add("Status", (Object)this.statusAsString()).add("DisabledReason", (Object)this.disabledReasonAsString()).add("InvitedTime", (Object)this.invitedTime()).add("UpdatedTime", (Object)this.updatedTime()).add("VolumeUsageInBytes", (Object)this.volumeUsageInBytes()).add("VolumeUsageUpdatedTime", (Object)this.volumeUsageUpdatedTime()).add("PercentOfGraphUtilization", (Object)this.percentOfGraphUtilization()).add("PercentOfGraphUtilizationUpdatedTime", (Object)this.percentOfGraphUtilizationUpdatedTime()).add("InvitationType", (Object)this.invitationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "EmailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "GraphArn": {
                return Optional.ofNullable(clazz.cast(this.graphArn()));
            }
            case "MasterId": {
                return Optional.ofNullable(clazz.cast(this.masterId()));
            }
            case "AdministratorId": {
                return Optional.ofNullable(clazz.cast(this.administratorId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "DisabledReason": {
                return Optional.ofNullable(clazz.cast(this.disabledReasonAsString()));
            }
            case "InvitedTime": {
                return Optional.ofNullable(clazz.cast(this.invitedTime()));
            }
            case "UpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.updatedTime()));
            }
            case "VolumeUsageInBytes": {
                return Optional.ofNullable(clazz.cast(this.volumeUsageInBytes()));
            }
            case "VolumeUsageUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.volumeUsageUpdatedTime()));
            }
            case "PercentOfGraphUtilization": {
                return Optional.ofNullable(clazz.cast(this.percentOfGraphUtilization()));
            }
            case "PercentOfGraphUtilizationUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.percentOfGraphUtilizationUpdatedTime()));
            }
            case "InvitationType": {
                return Optional.ofNullable(clazz.cast(this.invitationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemberDetail, T> g) {
        return obj -> g.apply((MemberDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String emailAddress;
        private String graphArn;
        private String masterId;
        private String administratorId;
        private String status;
        private String disabledReason;
        private Instant invitedTime;
        private Instant updatedTime;
        private Long volumeUsageInBytes;
        private Instant volumeUsageUpdatedTime;
        private Double percentOfGraphUtilization;
        private Instant percentOfGraphUtilizationUpdatedTime;
        private String invitationType;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberDetail model) {
            this.accountId(model.accountId);
            this.emailAddress(model.emailAddress);
            this.graphArn(model.graphArn);
            this.masterId(model.masterId);
            this.administratorId(model.administratorId);
            this.status(model.status);
            this.disabledReason(model.disabledReason);
            this.invitedTime(model.invitedTime);
            this.updatedTime(model.updatedTime);
            this.volumeUsageInBytes(model.volumeUsageInBytes);
            this.volumeUsageUpdatedTime(model.volumeUsageUpdatedTime);
            this.percentOfGraphUtilization(model.percentOfGraphUtilization);
            this.percentOfGraphUtilizationUpdatedTime(model.percentOfGraphUtilizationUpdatedTime);
            this.invitationType(model.invitationType);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        @Transient
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getGraphArn() {
            return this.graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        @Transient
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        @Deprecated
        public final String getMasterId() {
            return this.masterId;
        }

        @Deprecated
        public final void setMasterId(String masterId) {
            this.masterId = masterId;
        }

        @Override
        @Transient
        @Deprecated
        public final Builder masterId(String masterId) {
            this.masterId = masterId;
            return this;
        }

        public final String getAdministratorId() {
            return this.administratorId;
        }

        public final void setAdministratorId(String administratorId) {
            this.administratorId = administratorId;
        }

        @Override
        @Transient
        public final Builder administratorId(String administratorId) {
            this.administratorId = administratorId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(MemberStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDisabledReason() {
            return this.disabledReason;
        }

        public final void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        @Override
        @Transient
        public final Builder disabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
            return this;
        }

        @Override
        @Transient
        public final Builder disabledReason(MemberDisabledReason disabledReason) {
            this.disabledReason(disabledReason == null ? null : disabledReason.toString());
            return this;
        }

        public final Instant getInvitedTime() {
            return this.invitedTime;
        }

        public final void setInvitedTime(Instant invitedTime) {
            this.invitedTime = invitedTime;
        }

        @Override
        @Transient
        public final Builder invitedTime(Instant invitedTime) {
            this.invitedTime = invitedTime;
            return this;
        }

        public final Instant getUpdatedTime() {
            return this.updatedTime;
        }

        public final void setUpdatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
        }

        @Override
        @Transient
        public final Builder updatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        public final Long getVolumeUsageInBytes() {
            return this.volumeUsageInBytes;
        }

        public final void setVolumeUsageInBytes(Long volumeUsageInBytes) {
            this.volumeUsageInBytes = volumeUsageInBytes;
        }

        @Override
        @Transient
        public final Builder volumeUsageInBytes(Long volumeUsageInBytes) {
            this.volumeUsageInBytes = volumeUsageInBytes;
            return this;
        }

        public final Instant getVolumeUsageUpdatedTime() {
            return this.volumeUsageUpdatedTime;
        }

        public final void setVolumeUsageUpdatedTime(Instant volumeUsageUpdatedTime) {
            this.volumeUsageUpdatedTime = volumeUsageUpdatedTime;
        }

        @Override
        @Transient
        public final Builder volumeUsageUpdatedTime(Instant volumeUsageUpdatedTime) {
            this.volumeUsageUpdatedTime = volumeUsageUpdatedTime;
            return this;
        }

        @Deprecated
        public final Double getPercentOfGraphUtilization() {
            return this.percentOfGraphUtilization;
        }

        @Deprecated
        public final void setPercentOfGraphUtilization(Double percentOfGraphUtilization) {
            this.percentOfGraphUtilization = percentOfGraphUtilization;
        }

        @Override
        @Transient
        @Deprecated
        public final Builder percentOfGraphUtilization(Double percentOfGraphUtilization) {
            this.percentOfGraphUtilization = percentOfGraphUtilization;
            return this;
        }

        @Deprecated
        public final Instant getPercentOfGraphUtilizationUpdatedTime() {
            return this.percentOfGraphUtilizationUpdatedTime;
        }

        @Deprecated
        public final void setPercentOfGraphUtilizationUpdatedTime(Instant percentOfGraphUtilizationUpdatedTime) {
            this.percentOfGraphUtilizationUpdatedTime = percentOfGraphUtilizationUpdatedTime;
        }

        @Override
        @Transient
        @Deprecated
        public final Builder percentOfGraphUtilizationUpdatedTime(Instant percentOfGraphUtilizationUpdatedTime) {
            this.percentOfGraphUtilizationUpdatedTime = percentOfGraphUtilizationUpdatedTime;
            return this;
        }

        public final String getInvitationType() {
            return this.invitationType;
        }

        public final void setInvitationType(String invitationType) {
            this.invitationType = invitationType;
        }

        @Override
        @Transient
        public final Builder invitationType(String invitationType) {
            this.invitationType = invitationType;
            return this;
        }

        @Override
        @Transient
        public final Builder invitationType(InvitationType invitationType) {
            this.invitationType(invitationType == null ? null : invitationType.toString());
            return this;
        }

        public MemberDetail build() {
            return new MemberDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MemberDetail> {
        public Builder accountId(String var1);

        public Builder emailAddress(String var1);

        public Builder graphArn(String var1);

        @Deprecated
        public Builder masterId(String var1);

        public Builder administratorId(String var1);

        public Builder status(String var1);

        public Builder status(MemberStatus var1);

        public Builder disabledReason(String var1);

        public Builder disabledReason(MemberDisabledReason var1);

        public Builder invitedTime(Instant var1);

        public Builder updatedTime(Instant var1);

        public Builder volumeUsageInBytes(Long var1);

        public Builder volumeUsageUpdatedTime(Instant var1);

        @Deprecated
        public Builder percentOfGraphUtilization(Double var1);

        @Deprecated
        public Builder percentOfGraphUtilizationUpdatedTime(Instant var1);

        public Builder invitationType(String var1);

        public Builder invitationType(InvitationType var1);
    }
}

