/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.detective.model.DetectiveResponse;
import software.amazon.awssdk.services.detective.model.Graph;
import software.amazon.awssdk.services.detective.model.GraphListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGraphsResponse
extends DetectiveResponse
implements ToCopyableBuilder<Builder, ListGraphsResponse> {
    private static final SdkField<List<Graph>> GRAPH_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GraphList").getter(ListGraphsResponse.getter(ListGraphsResponse::graphList)).setter(ListGraphsResponse.setter(Builder::graphList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Graph::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListGraphsResponse.getter(ListGraphsResponse::nextToken)).setter(ListGraphsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<Graph> graphList;
    private final String nextToken;

    private ListGraphsResponse(BuilderImpl builder) {
        super(builder);
        this.graphList = builder.graphList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGraphList() {
        return this.graphList != null && !(this.graphList instanceof SdkAutoConstructList);
    }

    public final List<Graph> graphList() {
        return this.graphList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGraphList() ? this.graphList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGraphsResponse)) {
            return false;
        }
        ListGraphsResponse other = (ListGraphsResponse)((Object)obj);
        return this.hasGraphList() == other.hasGraphList() && Objects.equals(this.graphList(), other.graphList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListGraphsResponse").add("GraphList", this.hasGraphList() ? this.graphList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GraphList": {
                return Optional.ofNullable(clazz.cast(this.graphList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGraphsResponse, T> g) {
        return obj -> g.apply((ListGraphsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DetectiveResponse.BuilderImpl
    implements Builder {
        private List<Graph> graphList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGraphsResponse model) {
            super(model);
            this.graphList(model.graphList);
            this.nextToken(model.nextToken);
        }

        public final Collection<Graph.Builder> getGraphList() {
            if (this.graphList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.graphList != null ? (Collection)this.graphList.stream().map(Graph::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder graphList(Collection<Graph> graphList) {
            this.graphList = GraphListCopier.copy(graphList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder graphList(Graph ... graphList) {
            this.graphList(Arrays.asList(graphList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder graphList(Consumer<Graph.Builder> ... graphList) {
            this.graphList(Stream.of(graphList).map(c -> (Graph)((Graph.Builder)Graph.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGraphList(Collection<Graph.BuilderImpl> graphList) {
            this.graphList = GraphListCopier.copyFromBuilder(graphList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListGraphsResponse build() {
            return new ListGraphsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DetectiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGraphsResponse> {
        public Builder graphList(Collection<Graph> var1);

        public Builder graphList(Graph ... var1);

        public Builder graphList(Consumer<Graph.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

