/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.detective.model.MemberDisabledReason;
import software.amazon.awssdk.services.detective.model.MemberStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MemberDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MemberDetail> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MemberDetail.getter(MemberDetail::accountId)).setter(MemberDetail.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MemberDetail.getter(MemberDetail::emailAddress)).setter(MemberDetail.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()}).build();
    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MemberDetail.getter(MemberDetail::graphArn)).setter(MemberDetail.setter(Builder::graphArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()}).build();
    private static final SdkField<String> MASTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MemberDetail.getter(MemberDetail::masterId)).setter(MemberDetail.setter(Builder::masterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MemberDetail.getter(MemberDetail::statusAsString)).setter(MemberDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> DISABLED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MemberDetail.getter(MemberDetail::disabledReasonAsString)).setter(MemberDetail.setter(Builder::disabledReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledReason").build()}).build();
    private static final SdkField<Instant> INVITED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(MemberDetail.getter(MemberDetail::invitedTime)).setter(MemberDetail.setter(Builder::invitedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitedTime").build()}).build();
    private static final SdkField<Instant> UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(MemberDetail.getter(MemberDetail::updatedTime)).setter(MemberDetail.setter(Builder::updatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTime").build()}).build();
    private static final SdkField<Double> PERCENT_OF_GRAPH_UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(MemberDetail.getter(MemberDetail::percentOfGraphUtilization)).setter(MemberDetail.setter(Builder::percentOfGraphUtilization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentOfGraphUtilization").build()}).build();
    private static final SdkField<Instant> PERCENT_OF_GRAPH_UTILIZATION_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(MemberDetail.getter(MemberDetail::percentOfGraphUtilizationUpdatedTime)).setter(MemberDetail.setter(Builder::percentOfGraphUtilizationUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentOfGraphUtilizationUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, EMAIL_ADDRESS_FIELD, GRAPH_ARN_FIELD, MASTER_ID_FIELD, STATUS_FIELD, DISABLED_REASON_FIELD, INVITED_TIME_FIELD, UPDATED_TIME_FIELD, PERCENT_OF_GRAPH_UTILIZATION_FIELD, PERCENT_OF_GRAPH_UTILIZATION_UPDATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String emailAddress;
    private final String graphArn;
    private final String masterId;
    private final String status;
    private final String disabledReason;
    private final Instant invitedTime;
    private final Instant updatedTime;
    private final Double percentOfGraphUtilization;
    private final Instant percentOfGraphUtilizationUpdatedTime;

    private MemberDetail(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.emailAddress = builder.emailAddress;
        this.graphArn = builder.graphArn;
        this.masterId = builder.masterId;
        this.status = builder.status;
        this.disabledReason = builder.disabledReason;
        this.invitedTime = builder.invitedTime;
        this.updatedTime = builder.updatedTime;
        this.percentOfGraphUtilization = builder.percentOfGraphUtilization;
        this.percentOfGraphUtilizationUpdatedTime = builder.percentOfGraphUtilizationUpdatedTime;
    }

    public String accountId() {
        return this.accountId;
    }

    public String emailAddress() {
        return this.emailAddress;
    }

    public String graphArn() {
        return this.graphArn;
    }

    public String masterId() {
        return this.masterId;
    }

    public MemberStatus status() {
        return MemberStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public MemberDisabledReason disabledReason() {
        return MemberDisabledReason.fromValue(this.disabledReason);
    }

    public String disabledReasonAsString() {
        return this.disabledReason;
    }

    public Instant invitedTime() {
        return this.invitedTime;
    }

    public Instant updatedTime() {
        return this.updatedTime;
    }

    public Double percentOfGraphUtilization() {
        return this.percentOfGraphUtilization;
    }

    public Instant percentOfGraphUtilizationUpdatedTime() {
        return this.percentOfGraphUtilizationUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabledReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.invitedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentOfGraphUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentOfGraphUtilizationUpdatedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberDetail)) {
            return false;
        }
        MemberDetail other = (MemberDetail)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.graphArn(), other.graphArn()) && Objects.equals(this.masterId(), other.masterId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.disabledReasonAsString(), other.disabledReasonAsString()) && Objects.equals(this.invitedTime(), other.invitedTime()) && Objects.equals(this.updatedTime(), other.updatedTime()) && Objects.equals(this.percentOfGraphUtilization(), other.percentOfGraphUtilization()) && Objects.equals(this.percentOfGraphUtilizationUpdatedTime(), other.percentOfGraphUtilizationUpdatedTime());
    }

    public String toString() {
        return ToString.builder((String)"MemberDetail").add("AccountId", (Object)this.accountId()).add("EmailAddress", (Object)this.emailAddress()).add("GraphArn", (Object)this.graphArn()).add("MasterId", (Object)this.masterId()).add("Status", (Object)this.statusAsString()).add("DisabledReason", (Object)this.disabledReasonAsString()).add("InvitedTime", (Object)this.invitedTime()).add("UpdatedTime", (Object)this.updatedTime()).add("PercentOfGraphUtilization", (Object)this.percentOfGraphUtilization()).add("PercentOfGraphUtilizationUpdatedTime", (Object)this.percentOfGraphUtilizationUpdatedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "EmailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "GraphArn": {
                return Optional.ofNullable(clazz.cast(this.graphArn()));
            }
            case "MasterId": {
                return Optional.ofNullable(clazz.cast(this.masterId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "DisabledReason": {
                return Optional.ofNullable(clazz.cast(this.disabledReasonAsString()));
            }
            case "InvitedTime": {
                return Optional.ofNullable(clazz.cast(this.invitedTime()));
            }
            case "UpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.updatedTime()));
            }
            case "PercentOfGraphUtilization": {
                return Optional.ofNullable(clazz.cast(this.percentOfGraphUtilization()));
            }
            case "PercentOfGraphUtilizationUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.percentOfGraphUtilizationUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemberDetail, T> g) {
        return obj -> g.apply((MemberDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String emailAddress;
        private String graphArn;
        private String masterId;
        private String status;
        private String disabledReason;
        private Instant invitedTime;
        private Instant updatedTime;
        private Double percentOfGraphUtilization;
        private Instant percentOfGraphUtilizationUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberDetail model) {
            this.accountId(model.accountId);
            this.emailAddress(model.emailAddress);
            this.graphArn(model.graphArn);
            this.masterId(model.masterId);
            this.status(model.status);
            this.disabledReason(model.disabledReason);
            this.invitedTime(model.invitedTime);
            this.updatedTime(model.updatedTime);
            this.percentOfGraphUtilization(model.percentOfGraphUtilization);
            this.percentOfGraphUtilizationUpdatedTime(model.percentOfGraphUtilizationUpdatedTime);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final String getGraphArn() {
            return this.graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        public final String getMasterId() {
            return this.masterId;
        }

        @Override
        public final Builder masterId(String masterId) {
            this.masterId = masterId;
            return this;
        }

        public final void setMasterId(String masterId) {
            this.masterId = masterId;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MemberStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDisabledReasonAsString() {
            return this.disabledReason;
        }

        @Override
        public final Builder disabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
            return this;
        }

        @Override
        public final Builder disabledReason(MemberDisabledReason disabledReason) {
            this.disabledReason(disabledReason == null ? null : disabledReason.toString());
            return this;
        }

        public final void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        public final Instant getInvitedTime() {
            return this.invitedTime;
        }

        @Override
        public final Builder invitedTime(Instant invitedTime) {
            this.invitedTime = invitedTime;
            return this;
        }

        public final void setInvitedTime(Instant invitedTime) {
            this.invitedTime = invitedTime;
        }

        public final Instant getUpdatedTime() {
            return this.updatedTime;
        }

        @Override
        public final Builder updatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        public final void setUpdatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
        }

        public final Double getPercentOfGraphUtilization() {
            return this.percentOfGraphUtilization;
        }

        @Override
        public final Builder percentOfGraphUtilization(Double percentOfGraphUtilization) {
            this.percentOfGraphUtilization = percentOfGraphUtilization;
            return this;
        }

        public final void setPercentOfGraphUtilization(Double percentOfGraphUtilization) {
            this.percentOfGraphUtilization = percentOfGraphUtilization;
        }

        public final Instant getPercentOfGraphUtilizationUpdatedTime() {
            return this.percentOfGraphUtilizationUpdatedTime;
        }

        @Override
        public final Builder percentOfGraphUtilizationUpdatedTime(Instant percentOfGraphUtilizationUpdatedTime) {
            this.percentOfGraphUtilizationUpdatedTime = percentOfGraphUtilizationUpdatedTime;
            return this;
        }

        public final void setPercentOfGraphUtilizationUpdatedTime(Instant percentOfGraphUtilizationUpdatedTime) {
            this.percentOfGraphUtilizationUpdatedTime = percentOfGraphUtilizationUpdatedTime;
        }

        public MemberDetail build() {
            return new MemberDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MemberDetail> {
        public Builder accountId(String var1);

        public Builder emailAddress(String var1);

        public Builder graphArn(String var1);

        public Builder masterId(String var1);

        public Builder status(String var1);

        public Builder status(MemberStatus var1);

        public Builder disabledReason(String var1);

        public Builder disabledReason(MemberDisabledReason var1);

        public Builder invitedTime(Instant var1);

        public Builder updatedTime(Instant var1);

        public Builder percentOfGraphUtilization(Double var1);

        public Builder percentOfGraphUtilizationUpdatedTime(Instant var1);
    }
}

