/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMonitorRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, UpdateMonitorRequest> {
    private static final SdkField<String> MONITOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monitorId").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::monitorId)).setter(UpdateMonitorRequest.setter(Builder::monitorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("monitorId").build()}).build();
    private static final SdkField<String> SUBDOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subdomain").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::subdomain)).setter(UpdateMonitorRequest.setter(Builder::subdomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subdomain").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::displayName)).setter(UpdateMonitorRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateMonitorRequest.getter(UpdateMonitorRequest::roleArn)).setter(UpdateMonitorRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_ID_FIELD, SUBDOMAIN_FIELD, DISPLAY_NAME_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateMonitorRequest.memberNameToFieldInitializer();
    private final String monitorId;
    private final String subdomain;
    private final String displayName;
    private final String roleArn;

    private UpdateMonitorRequest(BuilderImpl builder) {
        super(builder);
        this.monitorId = builder.monitorId;
        this.subdomain = builder.subdomain;
        this.displayName = builder.displayName;
        this.roleArn = builder.roleArn;
    }

    public final String monitorId() {
        return this.monitorId;
    }

    public final String subdomain() {
        return this.subdomain;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subdomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMonitorRequest)) {
            return false;
        }
        UpdateMonitorRequest other = (UpdateMonitorRequest)((Object)obj);
        return Objects.equals(this.monitorId(), other.monitorId()) && Objects.equals(this.subdomain(), other.subdomain()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMonitorRequest").add("MonitorId", (Object)this.monitorId()).add("Subdomain", (Object)this.subdomain()).add("DisplayName", (Object)this.displayName()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "monitorId": {
                return Optional.ofNullable(clazz.cast(this.monitorId()));
            }
            case "subdomain": {
                return Optional.ofNullable(clazz.cast(this.subdomain()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("monitorId", MONITOR_ID_FIELD);
        map.put("subdomain", SUBDOMAIN_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMonitorRequest, T> g) {
        return obj -> g.apply((UpdateMonitorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String monitorId;
        private String subdomain;
        private String displayName;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMonitorRequest model) {
            super(model);
            this.monitorId(model.monitorId);
            this.subdomain(model.subdomain);
            this.displayName(model.displayName);
            this.roleArn(model.roleArn);
        }

        public final String getMonitorId() {
            return this.monitorId;
        }

        public final void setMonitorId(String monitorId) {
            this.monitorId = monitorId;
        }

        @Override
        public final Builder monitorId(String monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        public final String getSubdomain() {
            return this.subdomain;
        }

        public final void setSubdomain(String subdomain) {
            this.subdomain = subdomain;
        }

        @Override
        public final Builder subdomain(String subdomain) {
            this.subdomain = subdomain;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMonitorRequest build() {
            return new UpdateMonitorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMonitorRequest> {
        public Builder monitorId(String var1);

        public Builder subdomain(String var1);

        public Builder displayName(String var1);

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

