/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.services.deadline.model.FileSystemLocation;
import software.amazon.awssdk.services.deadline.model.FileSystemLocationsListCopier;
import software.amazon.awssdk.services.deadline.model.StorageProfileOperatingSystemFamily;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStorageProfileRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, UpdateStorageProfileRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateStorageProfileRequest.getter(UpdateStorageProfileRequest::clientToken)).setter(UpdateStorageProfileRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(UpdateStorageProfileRequest.getter(UpdateStorageProfileRequest::farmId)).setter(UpdateStorageProfileRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<String> STORAGE_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageProfileId").getter(UpdateStorageProfileRequest.getter(UpdateStorageProfileRequest::storageProfileId)).setter(UpdateStorageProfileRequest.setter(Builder::storageProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("storageProfileId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateStorageProfileRequest.getter(UpdateStorageProfileRequest::displayName)).setter(UpdateStorageProfileRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> OS_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("osFamily").getter(UpdateStorageProfileRequest.getter(UpdateStorageProfileRequest::osFamilyAsString)).setter(UpdateStorageProfileRequest.setter(Builder::osFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osFamily").build()}).build();
    private static final SdkField<List<FileSystemLocation>> FILE_SYSTEM_LOCATIONS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fileSystemLocationsToAdd").getter(UpdateStorageProfileRequest.getter(UpdateStorageProfileRequest::fileSystemLocationsToAdd)).setter(UpdateStorageProfileRequest.setter(Builder::fileSystemLocationsToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemLocationsToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileSystemLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FileSystemLocation>> FILE_SYSTEM_LOCATIONS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fileSystemLocationsToRemove").getter(UpdateStorageProfileRequest.getter(UpdateStorageProfileRequest::fileSystemLocationsToRemove)).setter(UpdateStorageProfileRequest.setter(Builder::fileSystemLocationsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemLocationsToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FileSystemLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, FARM_ID_FIELD, STORAGE_PROFILE_ID_FIELD, DISPLAY_NAME_FIELD, OS_FAMILY_FIELD, FILE_SYSTEM_LOCATIONS_TO_ADD_FIELD, FILE_SYSTEM_LOCATIONS_TO_REMOVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateStorageProfileRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String farmId;
    private final String storageProfileId;
    private final String displayName;
    private final String osFamily;
    private final List<FileSystemLocation> fileSystemLocationsToAdd;
    private final List<FileSystemLocation> fileSystemLocationsToRemove;

    private UpdateStorageProfileRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.farmId = builder.farmId;
        this.storageProfileId = builder.storageProfileId;
        this.displayName = builder.displayName;
        this.osFamily = builder.osFamily;
        this.fileSystemLocationsToAdd = builder.fileSystemLocationsToAdd;
        this.fileSystemLocationsToRemove = builder.fileSystemLocationsToRemove;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final String storageProfileId() {
        return this.storageProfileId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final StorageProfileOperatingSystemFamily osFamily() {
        return StorageProfileOperatingSystemFamily.fromValue(this.osFamily);
    }

    public final String osFamilyAsString() {
        return this.osFamily;
    }

    public final boolean hasFileSystemLocationsToAdd() {
        return this.fileSystemLocationsToAdd != null && !(this.fileSystemLocationsToAdd instanceof SdkAutoConstructList);
    }

    public final List<FileSystemLocation> fileSystemLocationsToAdd() {
        return this.fileSystemLocationsToAdd;
    }

    public final boolean hasFileSystemLocationsToRemove() {
        return this.fileSystemLocationsToRemove != null && !(this.fileSystemLocationsToRemove instanceof SdkAutoConstructList);
    }

    public final List<FileSystemLocation> fileSystemLocationsToRemove() {
        return this.fileSystemLocationsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.osFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileSystemLocationsToAdd() ? this.fileSystemLocationsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileSystemLocationsToRemove() ? this.fileSystemLocationsToRemove() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStorageProfileRequest)) {
            return false;
        }
        UpdateStorageProfileRequest other = (UpdateStorageProfileRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.storageProfileId(), other.storageProfileId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.osFamilyAsString(), other.osFamilyAsString()) && this.hasFileSystemLocationsToAdd() == other.hasFileSystemLocationsToAdd() && Objects.equals(this.fileSystemLocationsToAdd(), other.fileSystemLocationsToAdd()) && this.hasFileSystemLocationsToRemove() == other.hasFileSystemLocationsToRemove() && Objects.equals(this.fileSystemLocationsToRemove(), other.fileSystemLocationsToRemove());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStorageProfileRequest").add("ClientToken", (Object)this.clientToken()).add("FarmId", (Object)this.farmId()).add("StorageProfileId", (Object)this.storageProfileId()).add("DisplayName", (Object)this.displayName()).add("OsFamily", (Object)this.osFamilyAsString()).add("FileSystemLocationsToAdd", (Object)(this.fileSystemLocationsToAdd() == null ? null : "*** Sensitive Data Redacted ***")).add("FileSystemLocationsToRemove", (Object)(this.fileSystemLocationsToRemove() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "storageProfileId": {
                return Optional.ofNullable(clazz.cast(this.storageProfileId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "osFamily": {
                return Optional.ofNullable(clazz.cast(this.osFamilyAsString()));
            }
            case "fileSystemLocationsToAdd": {
                return Optional.ofNullable(clazz.cast(this.fileSystemLocationsToAdd()));
            }
            case "fileSystemLocationsToRemove": {
                return Optional.ofNullable(clazz.cast(this.fileSystemLocationsToRemove()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("X-Amz-Client-Token", CLIENT_TOKEN_FIELD);
        map.put("farmId", FARM_ID_FIELD);
        map.put("storageProfileId", STORAGE_PROFILE_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("osFamily", OS_FAMILY_FIELD);
        map.put("fileSystemLocationsToAdd", FILE_SYSTEM_LOCATIONS_TO_ADD_FIELD);
        map.put("fileSystemLocationsToRemove", FILE_SYSTEM_LOCATIONS_TO_REMOVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateStorageProfileRequest, T> g) {
        return obj -> g.apply((UpdateStorageProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String farmId;
        private String storageProfileId;
        private String displayName;
        private String osFamily;
        private List<FileSystemLocation> fileSystemLocationsToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<FileSystemLocation> fileSystemLocationsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStorageProfileRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.farmId(model.farmId);
            this.storageProfileId(model.storageProfileId);
            this.displayName(model.displayName);
            this.osFamily(model.osFamily);
            this.fileSystemLocationsToAdd(model.fileSystemLocationsToAdd);
            this.fileSystemLocationsToRemove(model.fileSystemLocationsToRemove);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getStorageProfileId() {
            return this.storageProfileId;
        }

        public final void setStorageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
        }

        @Override
        public final Builder storageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getOsFamily() {
            return this.osFamily;
        }

        public final void setOsFamily(String osFamily) {
            this.osFamily = osFamily;
        }

        @Override
        public final Builder osFamily(String osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        @Override
        public final Builder osFamily(StorageProfileOperatingSystemFamily osFamily) {
            this.osFamily(osFamily == null ? null : osFamily.toString());
            return this;
        }

        public final List<FileSystemLocation.Builder> getFileSystemLocationsToAdd() {
            List<FileSystemLocation.Builder> result = FileSystemLocationsListCopier.copyToBuilder(this.fileSystemLocationsToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystemLocationsToAdd(Collection<FileSystemLocation.BuilderImpl> fileSystemLocationsToAdd) {
            this.fileSystemLocationsToAdd = FileSystemLocationsListCopier.copyFromBuilder(fileSystemLocationsToAdd);
        }

        @Override
        public final Builder fileSystemLocationsToAdd(Collection<FileSystemLocation> fileSystemLocationsToAdd) {
            this.fileSystemLocationsToAdd = FileSystemLocationsListCopier.copy(fileSystemLocationsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocationsToAdd(FileSystemLocation ... fileSystemLocationsToAdd) {
            this.fileSystemLocationsToAdd(Arrays.asList(fileSystemLocationsToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocationsToAdd(Consumer<FileSystemLocation.Builder> ... fileSystemLocationsToAdd) {
            this.fileSystemLocationsToAdd(Stream.of(fileSystemLocationsToAdd).map(c -> (FileSystemLocation)((FileSystemLocation.Builder)FileSystemLocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FileSystemLocation.Builder> getFileSystemLocationsToRemove() {
            List<FileSystemLocation.Builder> result = FileSystemLocationsListCopier.copyToBuilder(this.fileSystemLocationsToRemove);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystemLocationsToRemove(Collection<FileSystemLocation.BuilderImpl> fileSystemLocationsToRemove) {
            this.fileSystemLocationsToRemove = FileSystemLocationsListCopier.copyFromBuilder(fileSystemLocationsToRemove);
        }

        @Override
        public final Builder fileSystemLocationsToRemove(Collection<FileSystemLocation> fileSystemLocationsToRemove) {
            this.fileSystemLocationsToRemove = FileSystemLocationsListCopier.copy(fileSystemLocationsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocationsToRemove(FileSystemLocation ... fileSystemLocationsToRemove) {
            this.fileSystemLocationsToRemove(Arrays.asList(fileSystemLocationsToRemove));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocationsToRemove(Consumer<FileSystemLocation.Builder> ... fileSystemLocationsToRemove) {
            this.fileSystemLocationsToRemove(Stream.of(fileSystemLocationsToRemove).map(c -> (FileSystemLocation)((FileSystemLocation.Builder)FileSystemLocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStorageProfileRequest build() {
            return new UpdateStorageProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStorageProfileRequest> {
        public Builder clientToken(String var1);

        public Builder farmId(String var1);

        public Builder storageProfileId(String var1);

        public Builder displayName(String var1);

        public Builder osFamily(String var1);

        public Builder osFamily(StorageProfileOperatingSystemFamily var1);

        public Builder fileSystemLocationsToAdd(Collection<FileSystemLocation> var1);

        public Builder fileSystemLocationsToAdd(FileSystemLocation ... var1);

        public Builder fileSystemLocationsToAdd(Consumer<FileSystemLocation.Builder> ... var1);

        public Builder fileSystemLocationsToRemove(Collection<FileSystemLocation> var1);

        public Builder fileSystemLocationsToRemove(FileSystemLocation ... var1);

        public Builder fileSystemLocationsToRemove(Consumer<FileSystemLocation.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

