/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HostConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HostConfiguration> {
    private static final SdkField<String> SCRIPT_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scriptBody").getter(HostConfiguration.getter(HostConfiguration::scriptBody)).setter(HostConfiguration.setter(Builder::scriptBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptBody").build()}).build();
    private static final SdkField<Integer> SCRIPT_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("scriptTimeoutSeconds").getter(HostConfiguration.getter(HostConfiguration::scriptTimeoutSeconds)).setter(HostConfiguration.setter(Builder::scriptTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptTimeoutSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRIPT_BODY_FIELD, SCRIPT_TIMEOUT_SECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HostConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String scriptBody;
    private final Integer scriptTimeoutSeconds;

    private HostConfiguration(BuilderImpl builder) {
        this.scriptBody = builder.scriptBody;
        this.scriptTimeoutSeconds = builder.scriptTimeoutSeconds;
    }

    public final String scriptBody() {
        return this.scriptBody;
    }

    public final Integer scriptTimeoutSeconds() {
        return this.scriptTimeoutSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptTimeoutSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostConfiguration)) {
            return false;
        }
        HostConfiguration other = (HostConfiguration)obj;
        return Objects.equals(this.scriptBody(), other.scriptBody()) && Objects.equals(this.scriptTimeoutSeconds(), other.scriptTimeoutSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"HostConfiguration").add("ScriptBody", (Object)(this.scriptBody() == null ? null : "*** Sensitive Data Redacted ***")).add("ScriptTimeoutSeconds", (Object)this.scriptTimeoutSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scriptBody": {
                return Optional.ofNullable(clazz.cast(this.scriptBody()));
            }
            case "scriptTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.scriptTimeoutSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scriptBody", SCRIPT_BODY_FIELD);
        map.put("scriptTimeoutSeconds", SCRIPT_TIMEOUT_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HostConfiguration, T> g) {
        return obj -> g.apply((HostConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scriptBody;
        private Integer scriptTimeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(HostConfiguration model) {
            this.scriptBody(model.scriptBody);
            this.scriptTimeoutSeconds(model.scriptTimeoutSeconds);
        }

        public final String getScriptBody() {
            return this.scriptBody;
        }

        public final void setScriptBody(String scriptBody) {
            this.scriptBody = scriptBody;
        }

        @Override
        public final Builder scriptBody(String scriptBody) {
            this.scriptBody = scriptBody;
            return this;
        }

        public final Integer getScriptTimeoutSeconds() {
            return this.scriptTimeoutSeconds;
        }

        public final void setScriptTimeoutSeconds(Integer scriptTimeoutSeconds) {
            this.scriptTimeoutSeconds = scriptTimeoutSeconds;
        }

        @Override
        public final Builder scriptTimeoutSeconds(Integer scriptTimeoutSeconds) {
            this.scriptTimeoutSeconds = scriptTimeoutSeconds;
            return this;
        }

        public HostConfiguration build() {
            return new HostConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HostConfiguration> {
        public Builder scriptBody(String var1);

        public Builder scriptTimeoutSeconds(Integer var1);
    }
}

