/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.StepParameter;
import software.amazon.awssdk.services.deadline.model.StepParameterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParameterSpace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParameterSpace> {
    private static final SdkField<List<StepParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parameters").getter(ParameterSpace.getter(ParameterSpace::parameters)).setter(ParameterSpace.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> COMBINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("combination").getter(ParameterSpace.getter(ParameterSpace::combination)).setter(ParameterSpace.setter(Builder::combination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("combination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETERS_FIELD, COMBINATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ParameterSpace.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<StepParameter> parameters;
    private final String combination;

    private ParameterSpace(BuilderImpl builder) {
        this.parameters = builder.parameters;
        this.combination = builder.combination;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<StepParameter> parameters() {
        return this.parameters;
    }

    public final String combination() {
        return this.combination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.combination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterSpace)) {
            return false;
        }
        ParameterSpace other = (ParameterSpace)obj;
        return this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.combination(), other.combination());
    }

    public final String toString() {
        return ToString.builder((String)"ParameterSpace").add("Parameters", this.hasParameters() ? this.parameters() : null).add("Combination", (Object)this.combination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "combination": {
                return Optional.ofNullable(clazz.cast(this.combination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("parameters", PARAMETERS_FIELD);
        map.put("combination", COMBINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParameterSpace, T> g) {
        return obj -> g.apply((ParameterSpace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<StepParameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private String combination;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterSpace model) {
            this.parameters(model.parameters);
            this.combination(model.combination);
        }

        public final List<StepParameter.Builder> getParameters() {
            List<StepParameter.Builder> result = StepParameterListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<StepParameter.BuilderImpl> parameters) {
            this.parameters = StepParameterListCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<StepParameter> parameters) {
            this.parameters = StepParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(StepParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<StepParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (StepParameter)((StepParameter.Builder)StepParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCombination() {
            return this.combination;
        }

        public final void setCombination(String combination) {
            this.combination = combination;
        }

        @Override
        public final Builder combination(String combination) {
            this.combination = combination;
            return this;
        }

        public ParameterSpace build() {
            return new ParameterSpace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParameterSpace> {
        public Builder parameters(Collection<StepParameter> var1);

        public Builder parameters(StepParameter ... var1);

        public Builder parameters(Consumer<StepParameter.Builder> ... var1);

        public Builder combination(String var1);
    }
}

