/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.EnvironmentEnterSessionActionDefinition;
import software.amazon.awssdk.services.deadline.model.EnvironmentExitSessionActionDefinition;
import software.amazon.awssdk.services.deadline.model.SyncInputJobAttachmentsSessionActionDefinition;
import software.amazon.awssdk.services.deadline.model.TaskRunSessionActionDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionActionDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionActionDefinition> {
    private static final SdkField<EnvironmentEnterSessionActionDefinition> ENV_ENTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("envEnter").getter(SessionActionDefinition.getter(SessionActionDefinition::envEnter)).setter(SessionActionDefinition.setter(Builder::envEnter)).constructor(EnvironmentEnterSessionActionDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("envEnter").build()}).build();
    private static final SdkField<EnvironmentExitSessionActionDefinition> ENV_EXIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("envExit").getter(SessionActionDefinition.getter(SessionActionDefinition::envExit)).setter(SessionActionDefinition.setter(Builder::envExit)).constructor(EnvironmentExitSessionActionDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("envExit").build()}).build();
    private static final SdkField<TaskRunSessionActionDefinition> TASK_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("taskRun").getter(SessionActionDefinition.getter(SessionActionDefinition::taskRun)).setter(SessionActionDefinition.setter(Builder::taskRun)).constructor(TaskRunSessionActionDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRun").build()}).build();
    private static final SdkField<SyncInputJobAttachmentsSessionActionDefinition> SYNC_INPUT_JOB_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("syncInputJobAttachments").getter(SessionActionDefinition.getter(SessionActionDefinition::syncInputJobAttachments)).setter(SessionActionDefinition.setter(Builder::syncInputJobAttachments)).constructor(SyncInputJobAttachmentsSessionActionDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncInputJobAttachments").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENV_ENTER_FIELD, ENV_EXIT_FIELD, TASK_RUN_FIELD, SYNC_INPUT_JOB_ATTACHMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SessionActionDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EnvironmentEnterSessionActionDefinition envEnter;
    private final EnvironmentExitSessionActionDefinition envExit;
    private final TaskRunSessionActionDefinition taskRun;
    private final SyncInputJobAttachmentsSessionActionDefinition syncInputJobAttachments;
    private final Type type;

    private SessionActionDefinition(BuilderImpl builder) {
        this.envEnter = builder.envEnter;
        this.envExit = builder.envExit;
        this.taskRun = builder.taskRun;
        this.syncInputJobAttachments = builder.syncInputJobAttachments;
        this.type = builder.type;
    }

    public final EnvironmentEnterSessionActionDefinition envEnter() {
        return this.envEnter;
    }

    public final EnvironmentExitSessionActionDefinition envExit() {
        return this.envExit;
    }

    public final TaskRunSessionActionDefinition taskRun() {
        return this.taskRun;
    }

    public final SyncInputJobAttachmentsSessionActionDefinition syncInputJobAttachments() {
        return this.syncInputJobAttachments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.envEnter());
        hashCode = 31 * hashCode + Objects.hashCode(this.envExit());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncInputJobAttachments());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionActionDefinition)) {
            return false;
        }
        SessionActionDefinition other = (SessionActionDefinition)obj;
        return Objects.equals(this.envEnter(), other.envEnter()) && Objects.equals(this.envExit(), other.envExit()) && Objects.equals(this.taskRun(), other.taskRun()) && Objects.equals(this.syncInputJobAttachments(), other.syncInputJobAttachments());
    }

    public final String toString() {
        return ToString.builder((String)"SessionActionDefinition").add("EnvEnter", (Object)this.envEnter()).add("EnvExit", (Object)this.envExit()).add("TaskRun", (Object)this.taskRun()).add("SyncInputJobAttachments", (Object)this.syncInputJobAttachments()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "envEnter": {
                return Optional.ofNullable(clazz.cast(this.envEnter()));
            }
            case "envExit": {
                return Optional.ofNullable(clazz.cast(this.envExit()));
            }
            case "taskRun": {
                return Optional.ofNullable(clazz.cast(this.taskRun()));
            }
            case "syncInputJobAttachments": {
                return Optional.ofNullable(clazz.cast(this.syncInputJobAttachments()));
            }
        }
        return Optional.empty();
    }

    public static SessionActionDefinition fromEnvEnter(EnvironmentEnterSessionActionDefinition envEnter) {
        return (SessionActionDefinition)SessionActionDefinition.builder().envEnter(envEnter).build();
    }

    public static SessionActionDefinition fromEnvEnter(Consumer<EnvironmentEnterSessionActionDefinition.Builder> envEnter) {
        EnvironmentEnterSessionActionDefinition.Builder builder = EnvironmentEnterSessionActionDefinition.builder();
        envEnter.accept(builder);
        return SessionActionDefinition.fromEnvEnter((EnvironmentEnterSessionActionDefinition)builder.build());
    }

    public static SessionActionDefinition fromEnvExit(EnvironmentExitSessionActionDefinition envExit) {
        return (SessionActionDefinition)SessionActionDefinition.builder().envExit(envExit).build();
    }

    public static SessionActionDefinition fromEnvExit(Consumer<EnvironmentExitSessionActionDefinition.Builder> envExit) {
        EnvironmentExitSessionActionDefinition.Builder builder = EnvironmentExitSessionActionDefinition.builder();
        envExit.accept(builder);
        return SessionActionDefinition.fromEnvExit((EnvironmentExitSessionActionDefinition)builder.build());
    }

    public static SessionActionDefinition fromTaskRun(TaskRunSessionActionDefinition taskRun) {
        return (SessionActionDefinition)SessionActionDefinition.builder().taskRun(taskRun).build();
    }

    public static SessionActionDefinition fromTaskRun(Consumer<TaskRunSessionActionDefinition.Builder> taskRun) {
        TaskRunSessionActionDefinition.Builder builder = TaskRunSessionActionDefinition.builder();
        taskRun.accept(builder);
        return SessionActionDefinition.fromTaskRun((TaskRunSessionActionDefinition)builder.build());
    }

    public static SessionActionDefinition fromSyncInputJobAttachments(SyncInputJobAttachmentsSessionActionDefinition syncInputJobAttachments) {
        return (SessionActionDefinition)SessionActionDefinition.builder().syncInputJobAttachments(syncInputJobAttachments).build();
    }

    public static SessionActionDefinition fromSyncInputJobAttachments(Consumer<SyncInputJobAttachmentsSessionActionDefinition.Builder> syncInputJobAttachments) {
        SyncInputJobAttachmentsSessionActionDefinition.Builder builder = SyncInputJobAttachmentsSessionActionDefinition.builder();
        syncInputJobAttachments.accept(builder);
        return SessionActionDefinition.fromSyncInputJobAttachments((SyncInputJobAttachmentsSessionActionDefinition)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("envEnter", ENV_ENTER_FIELD);
        map.put("envExit", ENV_EXIT_FIELD);
        map.put("taskRun", TASK_RUN_FIELD);
        map.put("syncInputJobAttachments", SYNC_INPUT_JOB_ATTACHMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionActionDefinition, T> g) {
        return obj -> g.apply((SessionActionDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ENV_ENTER,
        ENV_EXIT,
        TASK_RUN,
        SYNC_INPUT_JOB_ATTACHMENTS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EnvironmentEnterSessionActionDefinition envEnter;
        private EnvironmentExitSessionActionDefinition envExit;
        private TaskRunSessionActionDefinition taskRun;
        private SyncInputJobAttachmentsSessionActionDefinition syncInputJobAttachments;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SessionActionDefinition model) {
            this.envEnter(model.envEnter);
            this.envExit(model.envExit);
            this.taskRun(model.taskRun);
            this.syncInputJobAttachments(model.syncInputJobAttachments);
        }

        public final EnvironmentEnterSessionActionDefinition.Builder getEnvEnter() {
            return this.envEnter != null ? this.envEnter.toBuilder() : null;
        }

        public final void setEnvEnter(EnvironmentEnterSessionActionDefinition.BuilderImpl envEnter) {
            EnvironmentEnterSessionActionDefinition oldValue = this.envEnter;
            this.envEnter = envEnter != null ? envEnter.build() : null;
            this.handleUnionValueChange(Type.ENV_ENTER, oldValue, this.envEnter);
        }

        @Override
        public final Builder envEnter(EnvironmentEnterSessionActionDefinition envEnter) {
            EnvironmentEnterSessionActionDefinition oldValue = this.envEnter;
            this.envEnter = envEnter;
            this.handleUnionValueChange(Type.ENV_ENTER, oldValue, this.envEnter);
            return this;
        }

        public final EnvironmentExitSessionActionDefinition.Builder getEnvExit() {
            return this.envExit != null ? this.envExit.toBuilder() : null;
        }

        public final void setEnvExit(EnvironmentExitSessionActionDefinition.BuilderImpl envExit) {
            EnvironmentExitSessionActionDefinition oldValue = this.envExit;
            this.envExit = envExit != null ? envExit.build() : null;
            this.handleUnionValueChange(Type.ENV_EXIT, oldValue, this.envExit);
        }

        @Override
        public final Builder envExit(EnvironmentExitSessionActionDefinition envExit) {
            EnvironmentExitSessionActionDefinition oldValue = this.envExit;
            this.envExit = envExit;
            this.handleUnionValueChange(Type.ENV_EXIT, oldValue, this.envExit);
            return this;
        }

        public final TaskRunSessionActionDefinition.Builder getTaskRun() {
            return this.taskRun != null ? this.taskRun.toBuilder() : null;
        }

        public final void setTaskRun(TaskRunSessionActionDefinition.BuilderImpl taskRun) {
            TaskRunSessionActionDefinition oldValue = this.taskRun;
            this.taskRun = taskRun != null ? taskRun.build() : null;
            this.handleUnionValueChange(Type.TASK_RUN, oldValue, this.taskRun);
        }

        @Override
        public final Builder taskRun(TaskRunSessionActionDefinition taskRun) {
            TaskRunSessionActionDefinition oldValue = this.taskRun;
            this.taskRun = taskRun;
            this.handleUnionValueChange(Type.TASK_RUN, oldValue, this.taskRun);
            return this;
        }

        public final SyncInputJobAttachmentsSessionActionDefinition.Builder getSyncInputJobAttachments() {
            return this.syncInputJobAttachments != null ? this.syncInputJobAttachments.toBuilder() : null;
        }

        public final void setSyncInputJobAttachments(SyncInputJobAttachmentsSessionActionDefinition.BuilderImpl syncInputJobAttachments) {
            SyncInputJobAttachmentsSessionActionDefinition oldValue = this.syncInputJobAttachments;
            this.syncInputJobAttachments = syncInputJobAttachments != null ? syncInputJobAttachments.build() : null;
            this.handleUnionValueChange(Type.SYNC_INPUT_JOB_ATTACHMENTS, oldValue, this.syncInputJobAttachments);
        }

        @Override
        public final Builder syncInputJobAttachments(SyncInputJobAttachmentsSessionActionDefinition syncInputJobAttachments) {
            SyncInputJobAttachmentsSessionActionDefinition oldValue = this.syncInputJobAttachments;
            this.syncInputJobAttachments = syncInputJobAttachments;
            this.handleUnionValueChange(Type.SYNC_INPUT_JOB_ATTACHMENTS, oldValue, this.syncInputJobAttachments);
            return this;
        }

        public SessionActionDefinition build() {
            return new SessionActionDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionActionDefinition> {
        public Builder envEnter(EnvironmentEnterSessionActionDefinition var1);

        default public Builder envEnter(Consumer<EnvironmentEnterSessionActionDefinition.Builder> envEnter) {
            return this.envEnter((EnvironmentEnterSessionActionDefinition)((EnvironmentEnterSessionActionDefinition.Builder)EnvironmentEnterSessionActionDefinition.builder().applyMutation(envEnter)).build());
        }

        public Builder envExit(EnvironmentExitSessionActionDefinition var1);

        default public Builder envExit(Consumer<EnvironmentExitSessionActionDefinition.Builder> envExit) {
            return this.envExit((EnvironmentExitSessionActionDefinition)((EnvironmentExitSessionActionDefinition.Builder)EnvironmentExitSessionActionDefinition.builder().applyMutation(envExit)).build());
        }

        public Builder taskRun(TaskRunSessionActionDefinition var1);

        default public Builder taskRun(Consumer<TaskRunSessionActionDefinition.Builder> taskRun) {
            return this.taskRun((TaskRunSessionActionDefinition)((TaskRunSessionActionDefinition.Builder)TaskRunSessionActionDefinition.builder().applyMutation(taskRun)).build());
        }

        public Builder syncInputJobAttachments(SyncInputJobAttachmentsSessionActionDefinition var1);

        default public Builder syncInputJobAttachments(Consumer<SyncInputJobAttachmentsSessionActionDefinition.Builder> syncInputJobAttachments) {
            return this.syncInputJobAttachments((SyncInputJobAttachmentsSessionActionDefinition)((SyncInputJobAttachmentsSessionActionDefinition.Builder)SyncInputJobAttachmentsSessionActionDefinition.builder().applyMutation(syncInputJobAttachments)).build());
        }
    }
}

