/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.AllowedStorageProfileIdsCopier;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.DefaultQueueBudgetAction;
import software.amazon.awssdk.services.deadline.model.JobAttachmentSettings;
import software.amazon.awssdk.services.deadline.model.JobRunAsUser;
import software.amazon.awssdk.services.deadline.model.QueueBlockedReason;
import software.amazon.awssdk.services.deadline.model.QueueStatus;
import software.amazon.awssdk.services.deadline.model.RequiredFileSystemLocationNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQueueResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, GetQueueResponse> {
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(GetQueueResponse.getter(GetQueueResponse::queueId)).setter(GetQueueResponse.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(GetQueueResponse.getter(GetQueueResponse::displayName)).setter(GetQueueResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetQueueResponse.getter(GetQueueResponse::description)).setter(GetQueueResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(GetQueueResponse.getter(GetQueueResponse::farmId)).setter(GetQueueResponse.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("farmId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetQueueResponse.getter(GetQueueResponse::statusAsString)).setter(GetQueueResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DEFAULT_BUDGET_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultBudgetAction").getter(GetQueueResponse.getter(GetQueueResponse::defaultBudgetActionAsString)).setter(GetQueueResponse.setter(Builder::defaultBudgetAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultBudgetAction").build()}).build();
    private static final SdkField<String> BLOCKED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockedReason").getter(GetQueueResponse.getter(GetQueueResponse::blockedReasonAsString)).setter(GetQueueResponse.setter(Builder::blockedReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedReason").build()}).build();
    private static final SdkField<JobAttachmentSettings> JOB_ATTACHMENT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobAttachmentSettings").getter(GetQueueResponse.getter(GetQueueResponse::jobAttachmentSettings)).setter(GetQueueResponse.setter(Builder::jobAttachmentSettings)).constructor(JobAttachmentSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobAttachmentSettings").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetQueueResponse.getter(GetQueueResponse::roleArn)).setter(GetQueueResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<String>> REQUIRED_FILE_SYSTEM_LOCATION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("requiredFileSystemLocationNames").getter(GetQueueResponse.getter(GetQueueResponse::requiredFileSystemLocationNames)).setter(GetQueueResponse.setter(Builder::requiredFileSystemLocationNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredFileSystemLocationNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_STORAGE_PROFILE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedStorageProfileIds").getter(GetQueueResponse.getter(GetQueueResponse::allowedStorageProfileIds)).setter(GetQueueResponse.setter(Builder::allowedStorageProfileIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedStorageProfileIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<JobRunAsUser> JOB_RUN_AS_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobRunAsUser").getter(GetQueueResponse.getter(GetQueueResponse::jobRunAsUser)).setter(GetQueueResponse.setter(Builder::jobRunAsUser)).constructor(JobRunAsUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobRunAsUser").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetQueueResponse.getter(GetQueueResponse::createdAt)).setter(GetQueueResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(GetQueueResponse.getter(GetQueueResponse::createdBy)).setter(GetQueueResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetQueueResponse.getter(GetQueueResponse::updatedAt)).setter(GetQueueResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(GetQueueResponse.getter(GetQueueResponse::updatedBy)).setter(GetQueueResponse.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_ID_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, FARM_ID_FIELD, STATUS_FIELD, DEFAULT_BUDGET_ACTION_FIELD, BLOCKED_REASON_FIELD, JOB_ATTACHMENT_SETTINGS_FIELD, ROLE_ARN_FIELD, REQUIRED_FILE_SYSTEM_LOCATION_NAMES_FIELD, ALLOWED_STORAGE_PROFILE_IDS_FIELD, JOB_RUN_AS_USER_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetQueueResponse.memberNameToFieldInitializer();
    private final String queueId;
    private final String displayName;
    private final String description;
    private final String farmId;
    private final String status;
    private final String defaultBudgetAction;
    private final String blockedReason;
    private final JobAttachmentSettings jobAttachmentSettings;
    private final String roleArn;
    private final List<String> requiredFileSystemLocationNames;
    private final List<String> allowedStorageProfileIds;
    private final JobRunAsUser jobRunAsUser;
    private final Instant createdAt;
    private final String createdBy;
    private final Instant updatedAt;
    private final String updatedBy;

    private GetQueueResponse(BuilderImpl builder) {
        super(builder);
        this.queueId = builder.queueId;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.farmId = builder.farmId;
        this.status = builder.status;
        this.defaultBudgetAction = builder.defaultBudgetAction;
        this.blockedReason = builder.blockedReason;
        this.jobAttachmentSettings = builder.jobAttachmentSettings;
        this.roleArn = builder.roleArn;
        this.requiredFileSystemLocationNames = builder.requiredFileSystemLocationNames;
        this.allowedStorageProfileIds = builder.allowedStorageProfileIds;
        this.jobRunAsUser = builder.jobRunAsUser;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final QueueStatus status() {
        return QueueStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final DefaultQueueBudgetAction defaultBudgetAction() {
        return DefaultQueueBudgetAction.fromValue(this.defaultBudgetAction);
    }

    public final String defaultBudgetActionAsString() {
        return this.defaultBudgetAction;
    }

    public final QueueBlockedReason blockedReason() {
        return QueueBlockedReason.fromValue(this.blockedReason);
    }

    public final String blockedReasonAsString() {
        return this.blockedReason;
    }

    public final JobAttachmentSettings jobAttachmentSettings() {
        return this.jobAttachmentSettings;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasRequiredFileSystemLocationNames() {
        return this.requiredFileSystemLocationNames != null && !(this.requiredFileSystemLocationNames instanceof SdkAutoConstructList);
    }

    public final List<String> requiredFileSystemLocationNames() {
        return this.requiredFileSystemLocationNames;
    }

    public final boolean hasAllowedStorageProfileIds() {
        return this.allowedStorageProfileIds != null && !(this.allowedStorageProfileIds instanceof SdkAutoConstructList);
    }

    public final List<String> allowedStorageProfileIds() {
        return this.allowedStorageProfileIds;
    }

    public final JobRunAsUser jobRunAsUser() {
        return this.jobRunAsUser;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultBudgetActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockedReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobAttachmentSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequiredFileSystemLocationNames() ? this.requiredFileSystemLocationNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedStorageProfileIds() ? this.allowedStorageProfileIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRunAsUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueueResponse)) {
            return false;
        }
        GetQueueResponse other = (GetQueueResponse)((Object)obj);
        return Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.defaultBudgetActionAsString(), other.defaultBudgetActionAsString()) && Objects.equals(this.blockedReasonAsString(), other.blockedReasonAsString()) && Objects.equals(this.jobAttachmentSettings(), other.jobAttachmentSettings()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasRequiredFileSystemLocationNames() == other.hasRequiredFileSystemLocationNames() && Objects.equals(this.requiredFileSystemLocationNames(), other.requiredFileSystemLocationNames()) && this.hasAllowedStorageProfileIds() == other.hasAllowedStorageProfileIds() && Objects.equals(this.allowedStorageProfileIds(), other.allowedStorageProfileIds()) && Objects.equals(this.jobRunAsUser(), other.jobRunAsUser()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy());
    }

    public final String toString() {
        return ToString.builder((String)"GetQueueResponse").add("QueueId", (Object)this.queueId()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("FarmId", (Object)this.farmId()).add("Status", (Object)this.statusAsString()).add("DefaultBudgetAction", (Object)this.defaultBudgetActionAsString()).add("BlockedReason", (Object)this.blockedReasonAsString()).add("JobAttachmentSettings", (Object)this.jobAttachmentSettings()).add("RoleArn", (Object)this.roleArn()).add("RequiredFileSystemLocationNames", this.hasRequiredFileSystemLocationNames() ? this.requiredFileSystemLocationNames() : null).add("AllowedStorageProfileIds", this.hasAllowedStorageProfileIds() ? this.allowedStorageProfileIds() : null).add("JobRunAsUser", (Object)this.jobRunAsUser()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "defaultBudgetAction": {
                return Optional.ofNullable(clazz.cast(this.defaultBudgetActionAsString()));
            }
            case "blockedReason": {
                return Optional.ofNullable(clazz.cast(this.blockedReasonAsString()));
            }
            case "jobAttachmentSettings": {
                return Optional.ofNullable(clazz.cast(this.jobAttachmentSettings()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "requiredFileSystemLocationNames": {
                return Optional.ofNullable(clazz.cast(this.requiredFileSystemLocationNames()));
            }
            case "allowedStorageProfileIds": {
                return Optional.ofNullable(clazz.cast(this.allowedStorageProfileIds()));
            }
            case "jobRunAsUser": {
                return Optional.ofNullable(clazz.cast(this.jobRunAsUser()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("queueId", QUEUE_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("farmId", FARM_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("defaultBudgetAction", DEFAULT_BUDGET_ACTION_FIELD);
        map.put("blockedReason", BLOCKED_REASON_FIELD);
        map.put("jobAttachmentSettings", JOB_ATTACHMENT_SETTINGS_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("requiredFileSystemLocationNames", REQUIRED_FILE_SYSTEM_LOCATION_NAMES_FIELD);
        map.put("allowedStorageProfileIds", ALLOWED_STORAGE_PROFILE_IDS_FIELD);
        map.put("jobRunAsUser", JOB_RUN_AS_USER_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQueueResponse, T> g) {
        return obj -> g.apply((GetQueueResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private String queueId;
        private String displayName;
        private String description;
        private String farmId;
        private String status;
        private String defaultBudgetAction;
        private String blockedReason;
        private JobAttachmentSettings jobAttachmentSettings;
        private String roleArn;
        private List<String> requiredFileSystemLocationNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedStorageProfileIds = DefaultSdkAutoConstructList.getInstance();
        private JobRunAsUser jobRunAsUser;
        private Instant createdAt;
        private String createdBy;
        private Instant updatedAt;
        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueueResponse model) {
            super(model);
            this.queueId(model.queueId);
            this.displayName(model.displayName);
            this.description(model.description);
            this.farmId(model.farmId);
            this.status(model.status);
            this.defaultBudgetAction(model.defaultBudgetAction);
            this.blockedReason(model.blockedReason);
            this.jobAttachmentSettings(model.jobAttachmentSettings);
            this.roleArn(model.roleArn);
            this.requiredFileSystemLocationNames(model.requiredFileSystemLocationNames);
            this.allowedStorageProfileIds(model.allowedStorageProfileIds);
            this.jobRunAsUser(model.jobRunAsUser);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDefaultBudgetAction() {
            return this.defaultBudgetAction;
        }

        public final void setDefaultBudgetAction(String defaultBudgetAction) {
            this.defaultBudgetAction = defaultBudgetAction;
        }

        @Override
        public final Builder defaultBudgetAction(String defaultBudgetAction) {
            this.defaultBudgetAction = defaultBudgetAction;
            return this;
        }

        @Override
        public final Builder defaultBudgetAction(DefaultQueueBudgetAction defaultBudgetAction) {
            this.defaultBudgetAction(defaultBudgetAction == null ? null : defaultBudgetAction.toString());
            return this;
        }

        public final String getBlockedReason() {
            return this.blockedReason;
        }

        public final void setBlockedReason(String blockedReason) {
            this.blockedReason = blockedReason;
        }

        @Override
        public final Builder blockedReason(String blockedReason) {
            this.blockedReason = blockedReason;
            return this;
        }

        @Override
        public final Builder blockedReason(QueueBlockedReason blockedReason) {
            this.blockedReason(blockedReason == null ? null : blockedReason.toString());
            return this;
        }

        public final JobAttachmentSettings.Builder getJobAttachmentSettings() {
            return this.jobAttachmentSettings != null ? this.jobAttachmentSettings.toBuilder() : null;
        }

        public final void setJobAttachmentSettings(JobAttachmentSettings.BuilderImpl jobAttachmentSettings) {
            this.jobAttachmentSettings = jobAttachmentSettings != null ? jobAttachmentSettings.build() : null;
        }

        @Override
        public final Builder jobAttachmentSettings(JobAttachmentSettings jobAttachmentSettings) {
            this.jobAttachmentSettings = jobAttachmentSettings;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Collection<String> getRequiredFileSystemLocationNames() {
            if (this.requiredFileSystemLocationNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requiredFileSystemLocationNames;
        }

        public final void setRequiredFileSystemLocationNames(Collection<String> requiredFileSystemLocationNames) {
            this.requiredFileSystemLocationNames = RequiredFileSystemLocationNamesCopier.copy(requiredFileSystemLocationNames);
        }

        @Override
        public final Builder requiredFileSystemLocationNames(Collection<String> requiredFileSystemLocationNames) {
            this.requiredFileSystemLocationNames = RequiredFileSystemLocationNamesCopier.copy(requiredFileSystemLocationNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredFileSystemLocationNames(String ... requiredFileSystemLocationNames) {
            this.requiredFileSystemLocationNames(Arrays.asList(requiredFileSystemLocationNames));
            return this;
        }

        public final Collection<String> getAllowedStorageProfileIds() {
            if (this.allowedStorageProfileIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedStorageProfileIds;
        }

        public final void setAllowedStorageProfileIds(Collection<String> allowedStorageProfileIds) {
            this.allowedStorageProfileIds = AllowedStorageProfileIdsCopier.copy(allowedStorageProfileIds);
        }

        @Override
        public final Builder allowedStorageProfileIds(Collection<String> allowedStorageProfileIds) {
            this.allowedStorageProfileIds = AllowedStorageProfileIdsCopier.copy(allowedStorageProfileIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedStorageProfileIds(String ... allowedStorageProfileIds) {
            this.allowedStorageProfileIds(Arrays.asList(allowedStorageProfileIds));
            return this;
        }

        public final JobRunAsUser.Builder getJobRunAsUser() {
            return this.jobRunAsUser != null ? this.jobRunAsUser.toBuilder() : null;
        }

        public final void setJobRunAsUser(JobRunAsUser.BuilderImpl jobRunAsUser) {
            this.jobRunAsUser = jobRunAsUser != null ? jobRunAsUser.build() : null;
        }

        @Override
        public final Builder jobRunAsUser(JobRunAsUser jobRunAsUser) {
            this.jobRunAsUser = jobRunAsUser;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public GetQueueResponse build() {
            return new GetQueueResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQueueResponse> {
        public Builder queueId(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder farmId(String var1);

        public Builder status(String var1);

        public Builder status(QueueStatus var1);

        public Builder defaultBudgetAction(String var1);

        public Builder defaultBudgetAction(DefaultQueueBudgetAction var1);

        public Builder blockedReason(String var1);

        public Builder blockedReason(QueueBlockedReason var1);

        public Builder jobAttachmentSettings(JobAttachmentSettings var1);

        default public Builder jobAttachmentSettings(Consumer<JobAttachmentSettings.Builder> jobAttachmentSettings) {
            return this.jobAttachmentSettings((JobAttachmentSettings)((JobAttachmentSettings.Builder)JobAttachmentSettings.builder().applyMutation(jobAttachmentSettings)).build());
        }

        public Builder roleArn(String var1);

        public Builder requiredFileSystemLocationNames(Collection<String> var1);

        public Builder requiredFileSystemLocationNames(String ... var1);

        public Builder allowedStorageProfileIds(Collection<String> var1);

        public Builder allowedStorageProfileIds(String ... var1);

        public Builder jobRunAsUser(JobRunAsUser var1);

        default public Builder jobRunAsUser(Consumer<JobRunAsUser.Builder> jobRunAsUser) {
            return this.jobRunAsUser((JobRunAsUser)((JobRunAsUser.Builder)JobRunAsUser.builder().applyMutation(jobRunAsUser)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);
    }
}

