/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.PathFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PathMappingRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PathMappingRule> {
    private static final SdkField<String> SOURCE_PATH_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourcePathFormat").getter(PathMappingRule.getter(PathMappingRule::sourcePathFormatAsString)).setter(PathMappingRule.setter(Builder::sourcePathFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourcePathFormat").build()}).build();
    private static final SdkField<String> SOURCE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourcePath").getter(PathMappingRule.getter(PathMappingRule::sourcePath)).setter(PathMappingRule.setter(Builder::sourcePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourcePath").build()}).build();
    private static final SdkField<String> DESTINATION_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationPath").getter(PathMappingRule.getter(PathMappingRule::destinationPath)).setter(PathMappingRule.setter(Builder::destinationPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_PATH_FORMAT_FIELD, SOURCE_PATH_FIELD, DESTINATION_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PathMappingRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourcePathFormat;
    private final String sourcePath;
    private final String destinationPath;

    private PathMappingRule(BuilderImpl builder) {
        this.sourcePathFormat = builder.sourcePathFormat;
        this.sourcePath = builder.sourcePath;
        this.destinationPath = builder.destinationPath;
    }

    public final PathFormat sourcePathFormat() {
        return PathFormat.fromValue(this.sourcePathFormat);
    }

    public final String sourcePathFormatAsString() {
        return this.sourcePathFormat;
    }

    public final String sourcePath() {
        return this.sourcePath;
    }

    public final String destinationPath() {
        return this.destinationPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePathFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathMappingRule)) {
            return false;
        }
        PathMappingRule other = (PathMappingRule)obj;
        return Objects.equals(this.sourcePathFormatAsString(), other.sourcePathFormatAsString()) && Objects.equals(this.sourcePath(), other.sourcePath()) && Objects.equals(this.destinationPath(), other.destinationPath());
    }

    public final String toString() {
        return ToString.builder((String)"PathMappingRule").add("SourcePathFormat", (Object)this.sourcePathFormatAsString()).add("SourcePath", (Object)this.sourcePath()).add("DestinationPath", (Object)this.destinationPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourcePathFormat": {
                return Optional.ofNullable(clazz.cast(this.sourcePathFormatAsString()));
            }
            case "sourcePath": {
                return Optional.ofNullable(clazz.cast(this.sourcePath()));
            }
            case "destinationPath": {
                return Optional.ofNullable(clazz.cast(this.destinationPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("sourcePathFormat", SOURCE_PATH_FORMAT_FIELD);
        map.put("sourcePath", SOURCE_PATH_FIELD);
        map.put("destinationPath", DESTINATION_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PathMappingRule, T> g) {
        return obj -> g.apply((PathMappingRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourcePathFormat;
        private String sourcePath;
        private String destinationPath;

        private BuilderImpl() {
        }

        private BuilderImpl(PathMappingRule model) {
            this.sourcePathFormat(model.sourcePathFormat);
            this.sourcePath(model.sourcePath);
            this.destinationPath(model.destinationPath);
        }

        public final String getSourcePathFormat() {
            return this.sourcePathFormat;
        }

        public final void setSourcePathFormat(String sourcePathFormat) {
            this.sourcePathFormat = sourcePathFormat;
        }

        @Override
        public final Builder sourcePathFormat(String sourcePathFormat) {
            this.sourcePathFormat = sourcePathFormat;
            return this;
        }

        @Override
        public final Builder sourcePathFormat(PathFormat sourcePathFormat) {
            this.sourcePathFormat(sourcePathFormat == null ? null : sourcePathFormat.toString());
            return this;
        }

        public final String getSourcePath() {
            return this.sourcePath;
        }

        public final void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        @Override
        public final Builder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public final String getDestinationPath() {
            return this.destinationPath;
        }

        public final void setDestinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
        }

        @Override
        public final Builder destinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
            return this;
        }

        public PathMappingRule build() {
            return new PathMappingRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PathMappingRule> {
        public Builder sourcePathFormat(String var1);

        public Builder sourcePathFormat(PathFormat var1);

        public Builder sourcePath(String var1);

        public Builder destinationPath(String var1);
    }
}

