/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.AutoScalingStatus;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.FleetCapabilities;
import software.amazon.awssdk.services.deadline.model.FleetConfiguration;
import software.amazon.awssdk.services.deadline.model.FleetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFleetResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, GetFleetResponse> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fleetId").getter(GetFleetResponse.getter(GetFleetResponse::fleetId)).setter(GetFleetResponse.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetId").build()}).build();
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(GetFleetResponse.getter(GetFleetResponse::farmId)).setter(GetFleetResponse.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("farmId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(GetFleetResponse.getter(GetFleetResponse::displayName)).setter(GetFleetResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetFleetResponse.getter(GetFleetResponse::description)).setter(GetFleetResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetFleetResponse.getter(GetFleetResponse::statusAsString)).setter(GetFleetResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> AUTO_SCALING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autoScalingStatus").getter(GetFleetResponse.getter(GetFleetResponse::autoScalingStatusAsString)).setter(GetFleetResponse.setter(Builder::autoScalingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingStatus").build()}).build();
    private static final SdkField<Integer> TARGET_WORKER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("targetWorkerCount").getter(GetFleetResponse.getter(GetFleetResponse::targetWorkerCount)).setter(GetFleetResponse.setter(Builder::targetWorkerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetWorkerCount").build()}).build();
    private static final SdkField<Integer> WORKER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("workerCount").getter(GetFleetResponse.getter(GetFleetResponse::workerCount)).setter(GetFleetResponse.setter(Builder::workerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerCount").build()}).build();
    private static final SdkField<Integer> MIN_WORKER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minWorkerCount").getter(GetFleetResponse.getter(GetFleetResponse::minWorkerCount)).setter(GetFleetResponse.setter(Builder::minWorkerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minWorkerCount").build()}).build();
    private static final SdkField<Integer> MAX_WORKER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxWorkerCount").getter(GetFleetResponse.getter(GetFleetResponse::maxWorkerCount)).setter(GetFleetResponse.setter(Builder::maxWorkerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxWorkerCount").build()}).build();
    private static final SdkField<FleetConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(GetFleetResponse.getter(GetFleetResponse::configuration)).setter(GetFleetResponse.setter(Builder::configuration)).constructor(FleetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<FleetCapabilities> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("capabilities").getter(GetFleetResponse.getter(GetFleetResponse::capabilities)).setter(GetFleetResponse.setter(Builder::capabilities)).constructor(FleetCapabilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetFleetResponse.getter(GetFleetResponse::roleArn)).setter(GetFleetResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetFleetResponse.getter(GetFleetResponse::createdAt)).setter(GetFleetResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(GetFleetResponse.getter(GetFleetResponse::createdBy)).setter(GetFleetResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetFleetResponse.getter(GetFleetResponse::updatedAt)).setter(GetFleetResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(GetFleetResponse.getter(GetFleetResponse::updatedBy)).setter(GetFleetResponse.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, FARM_ID_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, AUTO_SCALING_STATUS_FIELD, TARGET_WORKER_COUNT_FIELD, WORKER_COUNT_FIELD, MIN_WORKER_COUNT_FIELD, MAX_WORKER_COUNT_FIELD, CONFIGURATION_FIELD, CAPABILITIES_FIELD, ROLE_ARN_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetFleetResponse.memberNameToFieldInitializer();
    private final String fleetId;
    private final String farmId;
    private final String displayName;
    private final String description;
    private final String status;
    private final String autoScalingStatus;
    private final Integer targetWorkerCount;
    private final Integer workerCount;
    private final Integer minWorkerCount;
    private final Integer maxWorkerCount;
    private final FleetConfiguration configuration;
    private final FleetCapabilities capabilities;
    private final String roleArn;
    private final Instant createdAt;
    private final String createdBy;
    private final Instant updatedAt;
    private final String updatedBy;

    private GetFleetResponse(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.farmId = builder.farmId;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.status = builder.status;
        this.autoScalingStatus = builder.autoScalingStatus;
        this.targetWorkerCount = builder.targetWorkerCount;
        this.workerCount = builder.workerCount;
        this.minWorkerCount = builder.minWorkerCount;
        this.maxWorkerCount = builder.maxWorkerCount;
        this.configuration = builder.configuration;
        this.capabilities = builder.capabilities;
        this.roleArn = builder.roleArn;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final FleetStatus status() {
        return FleetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final AutoScalingStatus autoScalingStatus() {
        return AutoScalingStatus.fromValue(this.autoScalingStatus);
    }

    public final String autoScalingStatusAsString() {
        return this.autoScalingStatus;
    }

    public final Integer targetWorkerCount() {
        return this.targetWorkerCount;
    }

    public final Integer workerCount() {
        return this.workerCount;
    }

    public final Integer minWorkerCount() {
        return this.minWorkerCount;
    }

    public final Integer maxWorkerCount() {
        return this.maxWorkerCount;
    }

    public final FleetConfiguration configuration() {
        return this.configuration;
    }

    public final FleetCapabilities capabilities() {
        return this.capabilities;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.minWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilities());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFleetResponse)) {
            return false;
        }
        GetFleetResponse other = (GetFleetResponse)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.autoScalingStatusAsString(), other.autoScalingStatusAsString()) && Objects.equals(this.targetWorkerCount(), other.targetWorkerCount()) && Objects.equals(this.workerCount(), other.workerCount()) && Objects.equals(this.minWorkerCount(), other.minWorkerCount()) && Objects.equals(this.maxWorkerCount(), other.maxWorkerCount()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.capabilities(), other.capabilities()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy());
    }

    public final String toString() {
        return ToString.builder((String)"GetFleetResponse").add("FleetId", (Object)this.fleetId()).add("FarmId", (Object)this.farmId()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("AutoScalingStatus", (Object)this.autoScalingStatusAsString()).add("TargetWorkerCount", (Object)this.targetWorkerCount()).add("WorkerCount", (Object)this.workerCount()).add("MinWorkerCount", (Object)this.minWorkerCount()).add("MaxWorkerCount", (Object)this.maxWorkerCount()).add("Configuration", (Object)this.configuration()).add("Capabilities", (Object)this.capabilities()).add("RoleArn", (Object)this.roleArn()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "autoScalingStatus": {
                return Optional.ofNullable(clazz.cast(this.autoScalingStatusAsString()));
            }
            case "targetWorkerCount": {
                return Optional.ofNullable(clazz.cast(this.targetWorkerCount()));
            }
            case "workerCount": {
                return Optional.ofNullable(clazz.cast(this.workerCount()));
            }
            case "minWorkerCount": {
                return Optional.ofNullable(clazz.cast(this.minWorkerCount()));
            }
            case "maxWorkerCount": {
                return Optional.ofNullable(clazz.cast(this.maxWorkerCount()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fleetId", FLEET_ID_FIELD);
        map.put("farmId", FARM_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("autoScalingStatus", AUTO_SCALING_STATUS_FIELD);
        map.put("targetWorkerCount", TARGET_WORKER_COUNT_FIELD);
        map.put("workerCount", WORKER_COUNT_FIELD);
        map.put("minWorkerCount", MIN_WORKER_COUNT_FIELD);
        map.put("maxWorkerCount", MAX_WORKER_COUNT_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("capabilities", CAPABILITIES_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFleetResponse, T> g) {
        return obj -> g.apply((GetFleetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private String fleetId;
        private String farmId;
        private String displayName;
        private String description;
        private String status;
        private String autoScalingStatus;
        private Integer targetWorkerCount;
        private Integer workerCount;
        private Integer minWorkerCount;
        private Integer maxWorkerCount;
        private FleetConfiguration configuration;
        private FleetCapabilities capabilities;
        private String roleArn;
        private Instant createdAt;
        private String createdBy;
        private Instant updatedAt;
        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFleetResponse model) {
            super(model);
            this.fleetId(model.fleetId);
            this.farmId(model.farmId);
            this.displayName(model.displayName);
            this.description(model.description);
            this.status(model.status);
            this.autoScalingStatus(model.autoScalingStatus);
            this.targetWorkerCount(model.targetWorkerCount);
            this.workerCount(model.workerCount);
            this.minWorkerCount(model.minWorkerCount);
            this.maxWorkerCount(model.maxWorkerCount);
            this.configuration(model.configuration);
            this.capabilities(model.capabilities);
            this.roleArn(model.roleArn);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FleetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAutoScalingStatus() {
            return this.autoScalingStatus;
        }

        public final void setAutoScalingStatus(String autoScalingStatus) {
            this.autoScalingStatus = autoScalingStatus;
        }

        @Override
        public final Builder autoScalingStatus(String autoScalingStatus) {
            this.autoScalingStatus = autoScalingStatus;
            return this;
        }

        @Override
        public final Builder autoScalingStatus(AutoScalingStatus autoScalingStatus) {
            this.autoScalingStatus(autoScalingStatus == null ? null : autoScalingStatus.toString());
            return this;
        }

        public final Integer getTargetWorkerCount() {
            return this.targetWorkerCount;
        }

        public final void setTargetWorkerCount(Integer targetWorkerCount) {
            this.targetWorkerCount = targetWorkerCount;
        }

        @Override
        public final Builder targetWorkerCount(Integer targetWorkerCount) {
            this.targetWorkerCount = targetWorkerCount;
            return this;
        }

        public final Integer getWorkerCount() {
            return this.workerCount;
        }

        public final void setWorkerCount(Integer workerCount) {
            this.workerCount = workerCount;
        }

        @Override
        public final Builder workerCount(Integer workerCount) {
            this.workerCount = workerCount;
            return this;
        }

        public final Integer getMinWorkerCount() {
            return this.minWorkerCount;
        }

        public final void setMinWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
        }

        @Override
        public final Builder minWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
            return this;
        }

        public final Integer getMaxWorkerCount() {
            return this.maxWorkerCount;
        }

        public final void setMaxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
        }

        @Override
        public final Builder maxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
            return this;
        }

        public final FleetConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(FleetConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(FleetConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final FleetCapabilities.Builder getCapabilities() {
            return this.capabilities != null ? this.capabilities.toBuilder() : null;
        }

        public final void setCapabilities(FleetCapabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(FleetCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public GetFleetResponse build() {
            return new GetFleetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFleetResponse> {
        public Builder fleetId(String var1);

        public Builder farmId(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(FleetStatus var1);

        public Builder autoScalingStatus(String var1);

        public Builder autoScalingStatus(AutoScalingStatus var1);

        public Builder targetWorkerCount(Integer var1);

        public Builder workerCount(Integer var1);

        public Builder minWorkerCount(Integer var1);

        public Builder maxWorkerCount(Integer var1);

        public Builder configuration(FleetConfiguration var1);

        default public Builder configuration(Consumer<FleetConfiguration.Builder> configuration) {
            return this.configuration((FleetConfiguration)((FleetConfiguration.Builder)FleetConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder capabilities(FleetCapabilities var1);

        default public Builder capabilities(Consumer<FleetCapabilities.Builder> capabilities) {
            return this.capabilities((FleetCapabilities)((FleetCapabilities.Builder)FleetCapabilities.builder().applyMutation(capabilities)).build());
        }

        public Builder roleArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);
    }
}

