/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListStepConsumersRequest;
import software.amazon.awssdk.services.deadline.model.ListStepConsumersResponse;
import software.amazon.awssdk.services.deadline.model.StepConsumer;

public class ListStepConsumersPublisher
implements SdkPublisher<ListStepConsumersResponse> {
    private final DeadlineAsyncClient client;
    private final ListStepConsumersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStepConsumersPublisher(DeadlineAsyncClient client, ListStepConsumersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStepConsumersPublisher(DeadlineAsyncClient client, ListStepConsumersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStepConsumersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStepConsumersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StepConsumer> consumers() {
        Function<ListStepConsumersResponse, Iterator> getIterator = response -> {
            if (response != null && response.consumers() != null) {
                return response.consumers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStepConsumersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStepConsumersResponseFetcher
    implements AsyncPageFetcher<ListStepConsumersResponse> {
        private ListStepConsumersResponseFetcher() {
        }

        public boolean hasNextPage(ListStepConsumersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStepConsumersResponse> nextPage(ListStepConsumersResponse previousPage) {
            if (previousPage == null) {
                return ListStepConsumersPublisher.this.client.listStepConsumers(ListStepConsumersPublisher.this.firstRequest);
            }
            return ListStepConsumersPublisher.this.client.listStepConsumers((ListStepConsumersRequest)((Object)ListStepConsumersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

