/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.WorkerSearchSummariesCopier;
import software.amazon.awssdk.services.deadline.model.WorkerSearchSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchWorkersResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, SearchWorkersResponse> {
    private static final SdkField<List<WorkerSearchSummary>> WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workers").getter(SearchWorkersResponse.getter(SearchWorkersResponse::workers)).setter(SearchWorkersResponse.setter(Builder::workers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkerSearchSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> NEXT_ITEM_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("nextItemOffset").getter(SearchWorkersResponse.getter(SearchWorkersResponse::nextItemOffset)).setter(SearchWorkersResponse.setter(Builder::nextItemOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextItemOffset").build()}).build();
    private static final SdkField<Integer> TOTAL_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalResults").getter(SearchWorkersResponse.getter(SearchWorkersResponse::totalResults)).setter(SearchWorkersResponse.setter(Builder::totalResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKERS_FIELD, NEXT_ITEM_OFFSET_FIELD, TOTAL_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchWorkersResponse.memberNameToFieldInitializer();
    private final List<WorkerSearchSummary> workers;
    private final Integer nextItemOffset;
    private final Integer totalResults;

    private SearchWorkersResponse(BuilderImpl builder) {
        super(builder);
        this.workers = builder.workers;
        this.nextItemOffset = builder.nextItemOffset;
        this.totalResults = builder.totalResults;
    }

    public final boolean hasWorkers() {
        return this.workers != null && !(this.workers instanceof SdkAutoConstructList);
    }

    public final List<WorkerSearchSummary> workers() {
        return this.workers;
    }

    public final Integer nextItemOffset() {
        return this.nextItemOffset;
    }

    public final Integer totalResults() {
        return this.totalResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkers() ? this.workers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextItemOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchWorkersResponse)) {
            return false;
        }
        SearchWorkersResponse other = (SearchWorkersResponse)((Object)obj);
        return this.hasWorkers() == other.hasWorkers() && Objects.equals(this.workers(), other.workers()) && Objects.equals(this.nextItemOffset(), other.nextItemOffset()) && Objects.equals(this.totalResults(), other.totalResults());
    }

    public final String toString() {
        return ToString.builder((String)"SearchWorkersResponse").add("Workers", this.hasWorkers() ? this.workers() : null).add("NextItemOffset", (Object)this.nextItemOffset()).add("TotalResults", (Object)this.totalResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workers": {
                return Optional.ofNullable(clazz.cast(this.workers()));
            }
            case "nextItemOffset": {
                return Optional.ofNullable(clazz.cast(this.nextItemOffset()));
            }
            case "totalResults": {
                return Optional.ofNullable(clazz.cast(this.totalResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workers", WORKERS_FIELD);
        map.put("nextItemOffset", NEXT_ITEM_OFFSET_FIELD);
        map.put("totalResults", TOTAL_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchWorkersResponse, T> g) {
        return obj -> g.apply((SearchWorkersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private List<WorkerSearchSummary> workers = DefaultSdkAutoConstructList.getInstance();
        private Integer nextItemOffset;
        private Integer totalResults;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchWorkersResponse model) {
            super(model);
            this.workers(model.workers);
            this.nextItemOffset(model.nextItemOffset);
            this.totalResults(model.totalResults);
        }

        public final List<WorkerSearchSummary.Builder> getWorkers() {
            List<WorkerSearchSummary.Builder> result = WorkerSearchSummariesCopier.copyToBuilder(this.workers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkers(Collection<WorkerSearchSummary.BuilderImpl> workers) {
            this.workers = WorkerSearchSummariesCopier.copyFromBuilder(workers);
        }

        @Override
        public final Builder workers(Collection<WorkerSearchSummary> workers) {
            this.workers = WorkerSearchSummariesCopier.copy(workers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workers(WorkerSearchSummary ... workers) {
            this.workers(Arrays.asList(workers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workers(Consumer<WorkerSearchSummary.Builder> ... workers) {
            this.workers(Stream.of(workers).map(c -> (WorkerSearchSummary)((WorkerSearchSummary.Builder)WorkerSearchSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getNextItemOffset() {
            return this.nextItemOffset;
        }

        public final void setNextItemOffset(Integer nextItemOffset) {
            this.nextItemOffset = nextItemOffset;
        }

        @Override
        public final Builder nextItemOffset(Integer nextItemOffset) {
            this.nextItemOffset = nextItemOffset;
            return this;
        }

        public final Integer getTotalResults() {
            return this.totalResults;
        }

        public final void setTotalResults(Integer totalResults) {
            this.totalResults = totalResults;
        }

        @Override
        public final Builder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        @Override
        public SearchWorkersResponse build() {
            return new SearchWorkersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchWorkersResponse> {
        public Builder workers(Collection<WorkerSearchSummary> var1);

        public Builder workers(WorkerSearchSummary ... var1);

        public Builder workers(Consumer<WorkerSearchSummary.Builder> ... var1);

        public Builder nextItemOffset(Integer var1);

        public Builder totalResults(Integer var1);
    }
}

