/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.FieldSortExpression;
import software.amazon.awssdk.services.deadline.model.ParameterSortExpression;
import software.amazon.awssdk.services.deadline.model.UserJobsFirst;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchSortExpression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchSortExpression> {
    private static final SdkField<UserJobsFirst> USER_JOBS_FIRST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("userJobsFirst").getter(SearchSortExpression.getter(SearchSortExpression::userJobsFirst)).setter(SearchSortExpression.setter(Builder::userJobsFirst)).constructor(UserJobsFirst::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userJobsFirst").build()}).build();
    private static final SdkField<FieldSortExpression> FIELD_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fieldSort").getter(SearchSortExpression.getter(SearchSortExpression::fieldSort)).setter(SearchSortExpression.setter(Builder::fieldSort)).constructor(FieldSortExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldSort").build()}).build();
    private static final SdkField<ParameterSortExpression> PARAMETER_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("parameterSort").getter(SearchSortExpression.getter(SearchSortExpression::parameterSort)).setter(SearchSortExpression.setter(Builder::parameterSort)).constructor(ParameterSortExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterSort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_JOBS_FIRST_FIELD, FIELD_SORT_FIELD, PARAMETER_SORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchSortExpression.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final UserJobsFirst userJobsFirst;
    private final FieldSortExpression fieldSort;
    private final ParameterSortExpression parameterSort;
    private final Type type;

    private SearchSortExpression(BuilderImpl builder) {
        this.userJobsFirst = builder.userJobsFirst;
        this.fieldSort = builder.fieldSort;
        this.parameterSort = builder.parameterSort;
        this.type = builder.type;
    }

    public final UserJobsFirst userJobsFirst() {
        return this.userJobsFirst;
    }

    public final FieldSortExpression fieldSort() {
        return this.fieldSort;
    }

    public final ParameterSortExpression parameterSort() {
        return this.parameterSort;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userJobsFirst());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldSort());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterSort());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSortExpression)) {
            return false;
        }
        SearchSortExpression other = (SearchSortExpression)obj;
        return Objects.equals(this.userJobsFirst(), other.userJobsFirst()) && Objects.equals(this.fieldSort(), other.fieldSort()) && Objects.equals(this.parameterSort(), other.parameterSort());
    }

    public final String toString() {
        return ToString.builder((String)"SearchSortExpression").add("UserJobsFirst", (Object)this.userJobsFirst()).add("FieldSort", (Object)this.fieldSort()).add("ParameterSort", (Object)this.parameterSort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userJobsFirst": {
                return Optional.ofNullable(clazz.cast(this.userJobsFirst()));
            }
            case "fieldSort": {
                return Optional.ofNullable(clazz.cast(this.fieldSort()));
            }
            case "parameterSort": {
                return Optional.ofNullable(clazz.cast(this.parameterSort()));
            }
        }
        return Optional.empty();
    }

    public static SearchSortExpression fromUserJobsFirst(UserJobsFirst userJobsFirst) {
        return (SearchSortExpression)SearchSortExpression.builder().userJobsFirst(userJobsFirst).build();
    }

    public static SearchSortExpression fromUserJobsFirst(Consumer<UserJobsFirst.Builder> userJobsFirst) {
        UserJobsFirst.Builder builder = UserJobsFirst.builder();
        userJobsFirst.accept(builder);
        return SearchSortExpression.fromUserJobsFirst((UserJobsFirst)builder.build());
    }

    public static SearchSortExpression fromFieldSort(FieldSortExpression fieldSort) {
        return (SearchSortExpression)SearchSortExpression.builder().fieldSort(fieldSort).build();
    }

    public static SearchSortExpression fromFieldSort(Consumer<FieldSortExpression.Builder> fieldSort) {
        FieldSortExpression.Builder builder = FieldSortExpression.builder();
        fieldSort.accept(builder);
        return SearchSortExpression.fromFieldSort((FieldSortExpression)builder.build());
    }

    public static SearchSortExpression fromParameterSort(ParameterSortExpression parameterSort) {
        return (SearchSortExpression)SearchSortExpression.builder().parameterSort(parameterSort).build();
    }

    public static SearchSortExpression fromParameterSort(Consumer<ParameterSortExpression.Builder> parameterSort) {
        ParameterSortExpression.Builder builder = ParameterSortExpression.builder();
        parameterSort.accept(builder);
        return SearchSortExpression.fromParameterSort((ParameterSortExpression)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userJobsFirst", USER_JOBS_FIRST_FIELD);
        map.put("fieldSort", FIELD_SORT_FIELD);
        map.put("parameterSort", PARAMETER_SORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchSortExpression, T> g) {
        return obj -> g.apply((SearchSortExpression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        USER_JOBS_FIRST,
        FIELD_SORT,
        PARAMETER_SORT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private UserJobsFirst userJobsFirst;
        private FieldSortExpression fieldSort;
        private ParameterSortExpression parameterSort;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSortExpression model) {
            this.userJobsFirst(model.userJobsFirst);
            this.fieldSort(model.fieldSort);
            this.parameterSort(model.parameterSort);
        }

        public final UserJobsFirst.Builder getUserJobsFirst() {
            return this.userJobsFirst != null ? this.userJobsFirst.toBuilder() : null;
        }

        public final void setUserJobsFirst(UserJobsFirst.BuilderImpl userJobsFirst) {
            UserJobsFirst oldValue = this.userJobsFirst;
            this.userJobsFirst = userJobsFirst != null ? userJobsFirst.build() : null;
            this.handleUnionValueChange(Type.USER_JOBS_FIRST, oldValue, this.userJobsFirst);
        }

        @Override
        public final Builder userJobsFirst(UserJobsFirst userJobsFirst) {
            UserJobsFirst oldValue = this.userJobsFirst;
            this.userJobsFirst = userJobsFirst;
            this.handleUnionValueChange(Type.USER_JOBS_FIRST, oldValue, this.userJobsFirst);
            return this;
        }

        public final FieldSortExpression.Builder getFieldSort() {
            return this.fieldSort != null ? this.fieldSort.toBuilder() : null;
        }

        public final void setFieldSort(FieldSortExpression.BuilderImpl fieldSort) {
            FieldSortExpression oldValue = this.fieldSort;
            this.fieldSort = fieldSort != null ? fieldSort.build() : null;
            this.handleUnionValueChange(Type.FIELD_SORT, oldValue, this.fieldSort);
        }

        @Override
        public final Builder fieldSort(FieldSortExpression fieldSort) {
            FieldSortExpression oldValue = this.fieldSort;
            this.fieldSort = fieldSort;
            this.handleUnionValueChange(Type.FIELD_SORT, oldValue, this.fieldSort);
            return this;
        }

        public final ParameterSortExpression.Builder getParameterSort() {
            return this.parameterSort != null ? this.parameterSort.toBuilder() : null;
        }

        public final void setParameterSort(ParameterSortExpression.BuilderImpl parameterSort) {
            ParameterSortExpression oldValue = this.parameterSort;
            this.parameterSort = parameterSort != null ? parameterSort.build() : null;
            this.handleUnionValueChange(Type.PARAMETER_SORT, oldValue, this.parameterSort);
        }

        @Override
        public final Builder parameterSort(ParameterSortExpression parameterSort) {
            ParameterSortExpression oldValue = this.parameterSort;
            this.parameterSort = parameterSort;
            this.handleUnionValueChange(Type.PARAMETER_SORT, oldValue, this.parameterSort);
            return this;
        }

        public SearchSortExpression build() {
            return new SearchSortExpression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchSortExpression> {
        public Builder userJobsFirst(UserJobsFirst var1);

        default public Builder userJobsFirst(Consumer<UserJobsFirst.Builder> userJobsFirst) {
            return this.userJobsFirst((UserJobsFirst)((UserJobsFirst.Builder)UserJobsFirst.builder().applyMutation(userJobsFirst)).build());
        }

        public Builder fieldSort(FieldSortExpression var1);

        default public Builder fieldSort(Consumer<FieldSortExpression.Builder> fieldSort) {
            return this.fieldSort((FieldSortExpression)((FieldSortExpression.Builder)FieldSortExpression.builder().applyMutation(fieldSort)).build());
        }

        public Builder parameterSort(ParameterSortExpression var1);

        default public Builder parameterSort(Consumer<ParameterSortExpression.Builder> parameterSort) {
            return this.parameterSort((ParameterSortExpression)((ParameterSortExpression.Builder)ParameterSortExpression.builder().applyMutation(parameterSort)).build());
        }
    }
}

