/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FileSystemLocationType {
    SHARED("SHARED"),
    LOCAL("LOCAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FileSystemLocationType> VALUE_MAP;
    private final String value;

    private FileSystemLocationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FileSystemLocationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FileSystemLocationType> knownValues() {
        EnumSet<FileSystemLocationType> knownValues = EnumSet.allOf(FileSystemLocationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FileSystemLocationType.class, FileSystemLocationType::toString);
    }
}

