/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MembershipLevel {
    VIEWER("VIEWER"),
    CONTRIBUTOR("CONTRIBUTOR"),
    OWNER("OWNER"),
    MANAGER("MANAGER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MembershipLevel> VALUE_MAP;
    private final String value;

    private MembershipLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MembershipLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MembershipLevel> knownValues() {
        EnumSet<MembershipLevel> knownValues = EnumSet.allOf(MembershipLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MembershipLevel.class, MembershipLevel::toString);
    }
}

