/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.services.deadline.model.HostPropertiesRequest;
import software.amazon.awssdk.services.deadline.model.UpdatedWorkerStatus;
import software.amazon.awssdk.services.deadline.model.WorkerCapabilities;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkerRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, UpdateWorkerRequest> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(UpdateWorkerRequest.getter(UpdateWorkerRequest::farmId)).setter(UpdateWorkerRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fleetId").getter(UpdateWorkerRequest.getter(UpdateWorkerRequest::fleetId)).setter(UpdateWorkerRequest.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("fleetId").build()}).build();
    private static final SdkField<String> WORKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workerId").getter(UpdateWorkerRequest.getter(UpdateWorkerRequest::workerId)).setter(UpdateWorkerRequest.setter(Builder::workerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workerId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateWorkerRequest.getter(UpdateWorkerRequest::statusAsString)).setter(UpdateWorkerRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<WorkerCapabilities> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("capabilities").getter(UpdateWorkerRequest.getter(UpdateWorkerRequest::capabilities)).setter(UpdateWorkerRequest.setter(Builder::capabilities)).constructor(WorkerCapabilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build()}).build();
    private static final SdkField<HostPropertiesRequest> HOST_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hostProperties").getter(UpdateWorkerRequest.getter(UpdateWorkerRequest::hostProperties)).setter(UpdateWorkerRequest.setter(Builder::hostProperties)).constructor(HostPropertiesRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD, FLEET_ID_FIELD, WORKER_ID_FIELD, STATUS_FIELD, CAPABILITIES_FIELD, HOST_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateWorkerRequest.memberNameToFieldInitializer();
    private final String farmId;
    private final String fleetId;
    private final String workerId;
    private final String status;
    private final WorkerCapabilities capabilities;
    private final HostPropertiesRequest hostProperties;

    private UpdateWorkerRequest(BuilderImpl builder) {
        super(builder);
        this.farmId = builder.farmId;
        this.fleetId = builder.fleetId;
        this.workerId = builder.workerId;
        this.status = builder.status;
        this.capabilities = builder.capabilities;
        this.hostProperties = builder.hostProperties;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String workerId() {
        return this.workerId;
    }

    public final UpdatedWorkerStatus status() {
        return UpdatedWorkerStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final WorkerCapabilities capabilities() {
        return this.capabilities;
    }

    public final HostPropertiesRequest hostProperties() {
        return this.hostProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilities());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkerRequest)) {
            return false;
        }
        UpdateWorkerRequest other = (UpdateWorkerRequest)((Object)obj);
        return Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.workerId(), other.workerId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.capabilities(), other.capabilities()) && Objects.equals(this.hostProperties(), other.hostProperties());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkerRequest").add("FarmId", (Object)this.farmId()).add("FleetId", (Object)this.fleetId()).add("WorkerId", (Object)this.workerId()).add("Status", (Object)this.statusAsString()).add("Capabilities", (Object)this.capabilities()).add("HostProperties", (Object)this.hostProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "fleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "workerId": {
                return Optional.ofNullable(clazz.cast(this.workerId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
            case "hostProperties": {
                return Optional.ofNullable(clazz.cast(this.hostProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("farmId", FARM_ID_FIELD);
        map.put("fleetId", FLEET_ID_FIELD);
        map.put("workerId", WORKER_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("capabilities", CAPABILITIES_FIELD);
        map.put("hostProperties", HOST_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkerRequest, T> g) {
        return obj -> g.apply((UpdateWorkerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String farmId;
        private String fleetId;
        private String workerId;
        private String status;
        private WorkerCapabilities capabilities;
        private HostPropertiesRequest hostProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkerRequest model) {
            super(model);
            this.farmId(model.farmId);
            this.fleetId(model.fleetId);
            this.workerId(model.workerId);
            this.status(model.status);
            this.capabilities(model.capabilities);
            this.hostProperties(model.hostProperties);
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getWorkerId() {
            return this.workerId;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UpdatedWorkerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final WorkerCapabilities.Builder getCapabilities() {
            return this.capabilities != null ? this.capabilities.toBuilder() : null;
        }

        public final void setCapabilities(WorkerCapabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(WorkerCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public final HostPropertiesRequest.Builder getHostProperties() {
            return this.hostProperties != null ? this.hostProperties.toBuilder() : null;
        }

        public final void setHostProperties(HostPropertiesRequest.BuilderImpl hostProperties) {
            this.hostProperties = hostProperties != null ? hostProperties.build() : null;
        }

        @Override
        public final Builder hostProperties(HostPropertiesRequest hostProperties) {
            this.hostProperties = hostProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkerRequest build() {
            return new UpdateWorkerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkerRequest> {
        public Builder farmId(String var1);

        public Builder fleetId(String var1);

        public Builder workerId(String var1);

        public Builder status(String var1);

        public Builder status(UpdatedWorkerStatus var1);

        public Builder capabilities(WorkerCapabilities var1);

        default public Builder capabilities(Consumer<WorkerCapabilities.Builder> capabilities) {
            return this.capabilities((WorkerCapabilities)((WorkerCapabilities.Builder)WorkerCapabilities.builder().applyMutation(capabilities)).build());
        }

        public Builder hostProperties(HostPropertiesRequest var1);

        default public Builder hostProperties(Consumer<HostPropertiesRequest.Builder> hostProperties) {
            return this.hostProperties((HostPropertiesRequest)((HostPropertiesRequest.Builder)HostPropertiesRequest.builder().applyMutation(hostProperties)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

