/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JobEntityErrorCode {
    ACCESS_DENIED_EXCEPTION("AccessDeniedException"),
    INTERNAL_SERVER_EXCEPTION("InternalServerException"),
    VALIDATION_EXCEPTION("ValidationException"),
    RESOURCE_NOT_FOUND_EXCEPTION("ResourceNotFoundException"),
    MAX_PAYLOAD_SIZE_EXCEEDED("MaxPayloadSizeExceeded"),
    CONFLICT_EXCEPTION("ConflictException"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JobEntityErrorCode> VALUE_MAP;
    private final String value;

    private JobEntityErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobEntityErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobEntityErrorCode> knownValues() {
        EnumSet<JobEntityErrorCode> knownValues = EnumSet.allOf(JobEntityErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JobEntityErrorCode.class, JobEntityErrorCode::toString);
    }
}

