/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListStepConsumersRequest;
import software.amazon.awssdk.services.deadline.model.ListStepConsumersResponse;
import software.amazon.awssdk.services.deadline.model.StepConsumer;

public class ListStepConsumersIterable
implements SdkIterable<ListStepConsumersResponse> {
    private final DeadlineClient client;
    private final ListStepConsumersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStepConsumersIterable(DeadlineClient client, ListStepConsumersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStepConsumersResponseFetcher();
    }

    public Iterator<ListStepConsumersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StepConsumer> consumers() {
        Function<ListStepConsumersResponse, Iterator> getIterator = response -> {
            if (response != null && response.consumers() != null) {
                return response.consumers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStepConsumersResponseFetcher
    implements SyncPageFetcher<ListStepConsumersResponse> {
        private ListStepConsumersResponseFetcher() {
        }

        public boolean hasNextPage(ListStepConsumersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStepConsumersResponse nextPage(ListStepConsumersResponse previousPage) {
            if (previousPage == null) {
                return ListStepConsumersIterable.this.client.listStepConsumers(ListStepConsumersIterable.this.firstRequest);
            }
            return ListStepConsumersIterable.this.client.listStepConsumers((ListStepConsumersRequest)((Object)ListStepConsumersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

