/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.ParameterSpace;
import software.amazon.awssdk.services.deadline.model.StepLifecycleStatus;
import software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus;
import software.amazon.awssdk.services.deadline.model.TaskRunStatus;
import software.amazon.awssdk.services.deadline.model.TaskRunStatusCountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StepSearchSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StepSearchSummary> {
    private static final SdkField<String> STEP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepId").getter(StepSearchSummary.getter(StepSearchSummary::stepId)).setter(StepSearchSummary.setter(Builder::stepId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepId").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(StepSearchSummary.getter(StepSearchSummary::jobId)).setter(StepSearchSummary.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(StepSearchSummary.getter(StepSearchSummary::queueId)).setter(StepSearchSummary.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StepSearchSummary.getter(StepSearchSummary::name)).setter(StepSearchSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> LIFECYCLE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleStatus").getter(StepSearchSummary.getter(StepSearchSummary::lifecycleStatusAsString)).setter(StepSearchSummary.setter(Builder::lifecycleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatus").build()}).build();
    private static final SdkField<String> LIFECYCLE_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleStatusMessage").getter(StepSearchSummary.getter(StepSearchSummary::lifecycleStatusMessage)).setter(StepSearchSummary.setter(Builder::lifecycleStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatusMessage").build()}).build();
    private static final SdkField<String> TASK_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskRunStatus").getter(StepSearchSummary.getter(StepSearchSummary::taskRunStatusAsString)).setter(StepSearchSummary.setter(Builder::taskRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRunStatus").build()}).build();
    private static final SdkField<String> TARGET_TASK_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetTaskRunStatus").getter(StepSearchSummary.getter(StepSearchSummary::targetTaskRunStatusAsString)).setter(StepSearchSummary.setter(Builder::targetTaskRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTaskRunStatus").build()}).build();
    private static final SdkField<Map<String, Integer>> TASK_RUN_STATUS_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("taskRunStatusCounts").getter(StepSearchSummary.getter(StepSearchSummary::taskRunStatusCountsAsStrings)).setter(StepSearchSummary.setter(Builder::taskRunStatusCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRunStatusCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(StepSearchSummary.getter(StepSearchSummary::createdAt)).setter(StepSearchSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(StepSearchSummary.getter(StepSearchSummary::startedAt)).setter(StepSearchSummary.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endedAt").getter(StepSearchSummary.getter(StepSearchSummary::endedAt)).setter(StepSearchSummary.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ParameterSpace> PARAMETER_SPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("parameterSpace").getter(StepSearchSummary.getter(StepSearchSummary::parameterSpace)).setter(StepSearchSummary.setter(Builder::parameterSpace)).constructor(ParameterSpace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterSpace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_ID_FIELD, JOB_ID_FIELD, QUEUE_ID_FIELD, NAME_FIELD, LIFECYCLE_STATUS_FIELD, LIFECYCLE_STATUS_MESSAGE_FIELD, TASK_RUN_STATUS_FIELD, TARGET_TASK_RUN_STATUS_FIELD, TASK_RUN_STATUS_COUNTS_FIELD, CREATED_AT_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD, PARAMETER_SPACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StepSearchSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stepId;
    private final String jobId;
    private final String queueId;
    private final String name;
    private final String lifecycleStatus;
    private final String lifecycleStatusMessage;
    private final String taskRunStatus;
    private final String targetTaskRunStatus;
    private final Map<String, Integer> taskRunStatusCounts;
    private final Instant createdAt;
    private final Instant startedAt;
    private final Instant endedAt;
    private final ParameterSpace parameterSpace;

    private StepSearchSummary(BuilderImpl builder) {
        this.stepId = builder.stepId;
        this.jobId = builder.jobId;
        this.queueId = builder.queueId;
        this.name = builder.name;
        this.lifecycleStatus = builder.lifecycleStatus;
        this.lifecycleStatusMessage = builder.lifecycleStatusMessage;
        this.taskRunStatus = builder.taskRunStatus;
        this.targetTaskRunStatus = builder.targetTaskRunStatus;
        this.taskRunStatusCounts = builder.taskRunStatusCounts;
        this.createdAt = builder.createdAt;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.parameterSpace = builder.parameterSpace;
    }

    public final String stepId() {
        return this.stepId;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final String name() {
        return this.name;
    }

    public final StepLifecycleStatus lifecycleStatus() {
        return StepLifecycleStatus.fromValue(this.lifecycleStatus);
    }

    public final String lifecycleStatusAsString() {
        return this.lifecycleStatus;
    }

    public final String lifecycleStatusMessage() {
        return this.lifecycleStatusMessage;
    }

    public final TaskRunStatus taskRunStatus() {
        return TaskRunStatus.fromValue(this.taskRunStatus);
    }

    public final String taskRunStatusAsString() {
        return this.taskRunStatus;
    }

    public final StepTargetTaskRunStatus targetTaskRunStatus() {
        return StepTargetTaskRunStatus.fromValue(this.targetTaskRunStatus);
    }

    public final String targetTaskRunStatusAsString() {
        return this.targetTaskRunStatus;
    }

    public final Map<TaskRunStatus, Integer> taskRunStatusCounts() {
        return TaskRunStatusCountsCopier.copyStringToEnum(this.taskRunStatusCounts);
    }

    public final boolean hasTaskRunStatusCounts() {
        return this.taskRunStatusCounts != null && !(this.taskRunStatusCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> taskRunStatusCountsAsStrings() {
        return this.taskRunStatusCounts;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final ParameterSpace parameterSpace() {
        return this.parameterSpace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stepId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTaskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskRunStatusCounts() ? this.taskRunStatusCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterSpace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepSearchSummary)) {
            return false;
        }
        StepSearchSummary other = (StepSearchSummary)obj;
        return Objects.equals(this.stepId(), other.stepId()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.lifecycleStatusAsString(), other.lifecycleStatusAsString()) && Objects.equals(this.lifecycleStatusMessage(), other.lifecycleStatusMessage()) && Objects.equals(this.taskRunStatusAsString(), other.taskRunStatusAsString()) && Objects.equals(this.targetTaskRunStatusAsString(), other.targetTaskRunStatusAsString()) && this.hasTaskRunStatusCounts() == other.hasTaskRunStatusCounts() && Objects.equals(this.taskRunStatusCountsAsStrings(), other.taskRunStatusCountsAsStrings()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.parameterSpace(), other.parameterSpace());
    }

    public final String toString() {
        return ToString.builder((String)"StepSearchSummary").add("StepId", (Object)this.stepId()).add("JobId", (Object)this.jobId()).add("QueueId", (Object)this.queueId()).add("Name", (Object)this.name()).add("LifecycleStatus", (Object)this.lifecycleStatusAsString()).add("LifecycleStatusMessage", (Object)this.lifecycleStatusMessage()).add("TaskRunStatus", (Object)this.taskRunStatusAsString()).add("TargetTaskRunStatus", (Object)this.targetTaskRunStatusAsString()).add("TaskRunStatusCounts", this.hasTaskRunStatusCounts() ? this.taskRunStatusCountsAsStrings() : null).add("CreatedAt", (Object)this.createdAt()).add("StartedAt", (Object)this.startedAt()).add("EndedAt", (Object)this.endedAt()).add("ParameterSpace", (Object)this.parameterSpace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stepId": {
                return Optional.ofNullable(clazz.cast(this.stepId()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "lifecycleStatus": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStatusAsString()));
            }
            case "lifecycleStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStatusMessage()));
            }
            case "taskRunStatus": {
                return Optional.ofNullable(clazz.cast(this.taskRunStatusAsString()));
            }
            case "targetTaskRunStatus": {
                return Optional.ofNullable(clazz.cast(this.targetTaskRunStatusAsString()));
            }
            case "taskRunStatusCounts": {
                return Optional.ofNullable(clazz.cast(this.taskRunStatusCountsAsStrings()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "endedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "parameterSpace": {
                return Optional.ofNullable(clazz.cast(this.parameterSpace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stepId", STEP_ID_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        map.put("queueId", QUEUE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("lifecycleStatus", LIFECYCLE_STATUS_FIELD);
        map.put("lifecycleStatusMessage", LIFECYCLE_STATUS_MESSAGE_FIELD);
        map.put("taskRunStatus", TASK_RUN_STATUS_FIELD);
        map.put("targetTaskRunStatus", TARGET_TASK_RUN_STATUS_FIELD);
        map.put("taskRunStatusCounts", TASK_RUN_STATUS_COUNTS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        map.put("parameterSpace", PARAMETER_SPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StepSearchSummary, T> g) {
        return obj -> g.apply((StepSearchSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stepId;
        private String jobId;
        private String queueId;
        private String name;
        private String lifecycleStatus;
        private String lifecycleStatusMessage;
        private String taskRunStatus;
        private String targetTaskRunStatus;
        private Map<String, Integer> taskRunStatusCounts = DefaultSdkAutoConstructMap.getInstance();
        private Instant createdAt;
        private Instant startedAt;
        private Instant endedAt;
        private ParameterSpace parameterSpace;

        private BuilderImpl() {
        }

        private BuilderImpl(StepSearchSummary model) {
            this.stepId(model.stepId);
            this.jobId(model.jobId);
            this.queueId(model.queueId);
            this.name(model.name);
            this.lifecycleStatus(model.lifecycleStatus);
            this.lifecycleStatusMessage(model.lifecycleStatusMessage);
            this.taskRunStatus(model.taskRunStatus);
            this.targetTaskRunStatus(model.targetTaskRunStatus);
            this.taskRunStatusCountsWithStrings(model.taskRunStatusCounts);
            this.createdAt(model.createdAt);
            this.startedAt(model.startedAt);
            this.endedAt(model.endedAt);
            this.parameterSpace(model.parameterSpace);
        }

        public final String getStepId() {
            return this.stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLifecycleStatus() {
            return this.lifecycleStatus;
        }

        public final void setLifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
        }

        @Override
        public final Builder lifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
            return this;
        }

        @Override
        public final Builder lifecycleStatus(StepLifecycleStatus lifecycleStatus) {
            this.lifecycleStatus(lifecycleStatus == null ? null : lifecycleStatus.toString());
            return this;
        }

        public final String getLifecycleStatusMessage() {
            return this.lifecycleStatusMessage;
        }

        public final void setLifecycleStatusMessage(String lifecycleStatusMessage) {
            this.lifecycleStatusMessage = lifecycleStatusMessage;
        }

        @Override
        public final Builder lifecycleStatusMessage(String lifecycleStatusMessage) {
            this.lifecycleStatusMessage = lifecycleStatusMessage;
            return this;
        }

        public final String getTaskRunStatus() {
            return this.taskRunStatus;
        }

        public final void setTaskRunStatus(String taskRunStatus) {
            this.taskRunStatus = taskRunStatus;
        }

        @Override
        public final Builder taskRunStatus(String taskRunStatus) {
            this.taskRunStatus = taskRunStatus;
            return this;
        }

        @Override
        public final Builder taskRunStatus(TaskRunStatus taskRunStatus) {
            this.taskRunStatus(taskRunStatus == null ? null : taskRunStatus.toString());
            return this;
        }

        public final String getTargetTaskRunStatus() {
            return this.targetTaskRunStatus;
        }

        public final void setTargetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
        }

        @Override
        public final Builder targetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
            return this;
        }

        @Override
        public final Builder targetTaskRunStatus(StepTargetTaskRunStatus targetTaskRunStatus) {
            this.targetTaskRunStatus(targetTaskRunStatus == null ? null : targetTaskRunStatus.toString());
            return this;
        }

        public final Map<String, Integer> getTaskRunStatusCounts() {
            if (this.taskRunStatusCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.taskRunStatusCounts;
        }

        public final void setTaskRunStatusCounts(Map<String, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copy(taskRunStatusCounts);
        }

        @Override
        public final Builder taskRunStatusCountsWithStrings(Map<String, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copy(taskRunStatusCounts);
            return this;
        }

        @Override
        public final Builder taskRunStatusCounts(Map<TaskRunStatus, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copyEnumToString(taskRunStatusCounts);
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final ParameterSpace.Builder getParameterSpace() {
            return this.parameterSpace != null ? this.parameterSpace.toBuilder() : null;
        }

        public final void setParameterSpace(ParameterSpace.BuilderImpl parameterSpace) {
            this.parameterSpace = parameterSpace != null ? parameterSpace.build() : null;
        }

        @Override
        public final Builder parameterSpace(ParameterSpace parameterSpace) {
            this.parameterSpace = parameterSpace;
            return this;
        }

        public StepSearchSummary build() {
            return new StepSearchSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StepSearchSummary> {
        public Builder stepId(String var1);

        public Builder jobId(String var1);

        public Builder queueId(String var1);

        public Builder name(String var1);

        public Builder lifecycleStatus(String var1);

        public Builder lifecycleStatus(StepLifecycleStatus var1);

        public Builder lifecycleStatusMessage(String var1);

        public Builder taskRunStatus(String var1);

        public Builder taskRunStatus(TaskRunStatus var1);

        public Builder targetTaskRunStatus(String var1);

        public Builder targetTaskRunStatus(StepTargetTaskRunStatus var1);

        public Builder taskRunStatusCountsWithStrings(Map<String, Integer> var1);

        public Builder taskRunStatusCounts(Map<TaskRunStatus, Integer> var1);

        public Builder createdAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder endedAt(Instant var1);

        public Builder parameterSpace(ParameterSpace var1);

        default public Builder parameterSpace(Consumer<ParameterSpace.Builder> parameterSpace) {
            return this.parameterSpace((ParameterSpace)((ParameterSpace.Builder)ParameterSpace.builder().applyMutation(parameterSpace)).build());
        }
    }
}

