/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationRequest;
import software.amazon.awssdk.services.deadline.model.GetSessionsStatisticsAggregationResponse;
import software.amazon.awssdk.services.deadline.model.Statistics;

public class GetSessionsStatisticsAggregationIterable
implements SdkIterable<GetSessionsStatisticsAggregationResponse> {
    private final DeadlineClient client;
    private final GetSessionsStatisticsAggregationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetSessionsStatisticsAggregationIterable(DeadlineClient client, GetSessionsStatisticsAggregationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetSessionsStatisticsAggregationResponseFetcher();
    }

    public Iterator<GetSessionsStatisticsAggregationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Statistics> statistics() {
        Function<GetSessionsStatisticsAggregationResponse, Iterator> getIterator = response -> {
            if (response != null && response.statistics() != null) {
                return response.statistics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetSessionsStatisticsAggregationResponseFetcher
    implements SyncPageFetcher<GetSessionsStatisticsAggregationResponse> {
        private GetSessionsStatisticsAggregationResponseFetcher() {
        }

        public boolean hasNextPage(GetSessionsStatisticsAggregationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetSessionsStatisticsAggregationResponse nextPage(GetSessionsStatisticsAggregationResponse previousPage) {
            if (previousPage == null) {
                return GetSessionsStatisticsAggregationIterable.this.client.getSessionsStatisticsAggregation(GetSessionsStatisticsAggregationIterable.this.firstRequest);
            }
            return GetSessionsStatisticsAggregationIterable.this.client.getSessionsStatisticsAggregation((GetSessionsStatisticsAggregationRequest)((Object)GetSessionsStatisticsAggregationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

