/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.JobAttachmentSettings;
import software.amazon.awssdk.services.deadline.model.JobParameter;
import software.amazon.awssdk.services.deadline.model.JobParametersCopier;
import software.amazon.awssdk.services.deadline.model.JobRunAsUser;
import software.amazon.awssdk.services.deadline.model.PathMappingRule;
import software.amazon.awssdk.services.deadline.model.PathMappingRulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobDetailsEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobDetailsEntity> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(JobDetailsEntity.getter(JobDetailsEntity::jobId)).setter(JobDetailsEntity.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<JobAttachmentSettings> JOB_ATTACHMENT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobAttachmentSettings").getter(JobDetailsEntity.getter(JobDetailsEntity::jobAttachmentSettings)).setter(JobDetailsEntity.setter(Builder::jobAttachmentSettings)).constructor(JobAttachmentSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobAttachmentSettings").build()}).build();
    private static final SdkField<JobRunAsUser> JOB_RUN_AS_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobRunAsUser").getter(JobDetailsEntity.getter(JobDetailsEntity::jobRunAsUser)).setter(JobDetailsEntity.setter(Builder::jobRunAsUser)).constructor(JobRunAsUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobRunAsUser").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(JobDetailsEntity.getter(JobDetailsEntity::logGroupName)).setter(JobDetailsEntity.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<String> QUEUE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueRoleArn").getter(JobDetailsEntity.getter(JobDetailsEntity::queueRoleArn)).setter(JobDetailsEntity.setter(Builder::queueRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueRoleArn").build()}).build();
    private static final SdkField<Map<String, JobParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(JobDetailsEntity.getter(JobDetailsEntity::parameters)).setter(JobDetailsEntity.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schemaVersion").getter(JobDetailsEntity.getter(JobDetailsEntity::schemaVersion)).setter(JobDetailsEntity.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()}).build();
    private static final SdkField<List<PathMappingRule>> PATH_MAPPING_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pathMappingRules").getter(JobDetailsEntity.getter(JobDetailsEntity::pathMappingRules)).setter(JobDetailsEntity.setter(Builder::pathMappingRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pathMappingRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PathMappingRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_ATTACHMENT_SETTINGS_FIELD, JOB_RUN_AS_USER_FIELD, LOG_GROUP_NAME_FIELD, QUEUE_ROLE_ARN_FIELD, PARAMETERS_FIELD, SCHEMA_VERSION_FIELD, PATH_MAPPING_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("jobId", JOB_ID_FIELD);
            this.put("jobAttachmentSettings", JOB_ATTACHMENT_SETTINGS_FIELD);
            this.put("jobRunAsUser", JOB_RUN_AS_USER_FIELD);
            this.put("logGroupName", LOG_GROUP_NAME_FIELD);
            this.put("queueRoleArn", QUEUE_ROLE_ARN_FIELD);
            this.put("parameters", PARAMETERS_FIELD);
            this.put("schemaVersion", SCHEMA_VERSION_FIELD);
            this.put("pathMappingRules", PATH_MAPPING_RULES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final JobAttachmentSettings jobAttachmentSettings;
    private final JobRunAsUser jobRunAsUser;
    private final String logGroupName;
    private final String queueRoleArn;
    private final Map<String, JobParameter> parameters;
    private final String schemaVersion;
    private final List<PathMappingRule> pathMappingRules;

    private JobDetailsEntity(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobAttachmentSettings = builder.jobAttachmentSettings;
        this.jobRunAsUser = builder.jobRunAsUser;
        this.logGroupName = builder.logGroupName;
        this.queueRoleArn = builder.queueRoleArn;
        this.parameters = builder.parameters;
        this.schemaVersion = builder.schemaVersion;
        this.pathMappingRules = builder.pathMappingRules;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final JobAttachmentSettings jobAttachmentSettings() {
        return this.jobAttachmentSettings;
    }

    public final JobRunAsUser jobRunAsUser() {
        return this.jobRunAsUser;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final String queueRoleArn() {
        return this.queueRoleArn;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, JobParameter> parameters() {
        return this.parameters;
    }

    public final String schemaVersion() {
        return this.schemaVersion;
    }

    public final boolean hasPathMappingRules() {
        return this.pathMappingRules != null && !(this.pathMappingRules instanceof SdkAutoConstructList);
    }

    public final List<PathMappingRule> pathMappingRules() {
        return this.pathMappingRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobAttachmentSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRunAsUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPathMappingRules() ? this.pathMappingRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDetailsEntity)) {
            return false;
        }
        JobDetailsEntity other = (JobDetailsEntity)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobAttachmentSettings(), other.jobAttachmentSettings()) && Objects.equals(this.jobRunAsUser(), other.jobRunAsUser()) && Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.queueRoleArn(), other.queueRoleArn()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.schemaVersion(), other.schemaVersion()) && this.hasPathMappingRules() == other.hasPathMappingRules() && Objects.equals(this.pathMappingRules(), other.pathMappingRules());
    }

    public final String toString() {
        return ToString.builder((String)"JobDetailsEntity").add("JobId", (Object)this.jobId()).add("JobAttachmentSettings", (Object)this.jobAttachmentSettings()).add("JobRunAsUser", (Object)this.jobRunAsUser()).add("LogGroupName", (Object)this.logGroupName()).add("QueueRoleArn", (Object)this.queueRoleArn()).add("Parameters", (Object)(this.parameters() == null ? null : "*** Sensitive Data Redacted ***")).add("SchemaVersion", (Object)this.schemaVersion()).add("PathMappingRules", (Object)(this.pathMappingRules() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "jobAttachmentSettings": {
                return Optional.ofNullable(clazz.cast(this.jobAttachmentSettings()));
            }
            case "jobRunAsUser": {
                return Optional.ofNullable(clazz.cast(this.jobRunAsUser()));
            }
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "queueRoleArn": {
                return Optional.ofNullable(clazz.cast(this.queueRoleArn()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "schemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersion()));
            }
            case "pathMappingRules": {
                return Optional.ofNullable(clazz.cast(this.pathMappingRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<JobDetailsEntity, T> g) {
        return obj -> g.apply((JobDetailsEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private JobAttachmentSettings jobAttachmentSettings;
        private JobRunAsUser jobRunAsUser;
        private String logGroupName;
        private String queueRoleArn;
        private Map<String, JobParameter> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String schemaVersion;
        private List<PathMappingRule> pathMappingRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobDetailsEntity model) {
            this.jobId(model.jobId);
            this.jobAttachmentSettings(model.jobAttachmentSettings);
            this.jobRunAsUser(model.jobRunAsUser);
            this.logGroupName(model.logGroupName);
            this.queueRoleArn(model.queueRoleArn);
            this.parameters(model.parameters);
            this.schemaVersion(model.schemaVersion);
            this.pathMappingRules(model.pathMappingRules);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final JobAttachmentSettings.Builder getJobAttachmentSettings() {
            return this.jobAttachmentSettings != null ? this.jobAttachmentSettings.toBuilder() : null;
        }

        public final void setJobAttachmentSettings(JobAttachmentSettings.BuilderImpl jobAttachmentSettings) {
            this.jobAttachmentSettings = jobAttachmentSettings != null ? jobAttachmentSettings.build() : null;
        }

        @Override
        public final Builder jobAttachmentSettings(JobAttachmentSettings jobAttachmentSettings) {
            this.jobAttachmentSettings = jobAttachmentSettings;
            return this;
        }

        public final JobRunAsUser.Builder getJobRunAsUser() {
            return this.jobRunAsUser != null ? this.jobRunAsUser.toBuilder() : null;
        }

        public final void setJobRunAsUser(JobRunAsUser.BuilderImpl jobRunAsUser) {
            this.jobRunAsUser = jobRunAsUser != null ? jobRunAsUser.build() : null;
        }

        @Override
        public final Builder jobRunAsUser(JobRunAsUser jobRunAsUser) {
            this.jobRunAsUser = jobRunAsUser;
            return this;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getQueueRoleArn() {
            return this.queueRoleArn;
        }

        public final void setQueueRoleArn(String queueRoleArn) {
            this.queueRoleArn = queueRoleArn;
        }

        @Override
        public final Builder queueRoleArn(String queueRoleArn) {
            this.queueRoleArn = queueRoleArn;
            return this;
        }

        public final Map<String, JobParameter.Builder> getParameters() {
            Map<String, JobParameter.Builder> result = JobParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, JobParameter.BuilderImpl> parameters) {
            this.parameters = JobParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, JobParameter> parameters) {
            this.parameters = JobParametersCopier.copy(parameters);
            return this;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final List<PathMappingRule.Builder> getPathMappingRules() {
            List<PathMappingRule.Builder> result = PathMappingRulesCopier.copyToBuilder(this.pathMappingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPathMappingRules(Collection<PathMappingRule.BuilderImpl> pathMappingRules) {
            this.pathMappingRules = PathMappingRulesCopier.copyFromBuilder(pathMappingRules);
        }

        @Override
        public final Builder pathMappingRules(Collection<PathMappingRule> pathMappingRules) {
            this.pathMappingRules = PathMappingRulesCopier.copy(pathMappingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pathMappingRules(PathMappingRule ... pathMappingRules) {
            this.pathMappingRules(Arrays.asList(pathMappingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pathMappingRules(Consumer<PathMappingRule.Builder> ... pathMappingRules) {
            this.pathMappingRules(Stream.of(pathMappingRules).map(c -> (PathMappingRule)((PathMappingRule.Builder)PathMappingRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public JobDetailsEntity build() {
            return new JobDetailsEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobDetailsEntity> {
        public Builder jobId(String var1);

        public Builder jobAttachmentSettings(JobAttachmentSettings var1);

        default public Builder jobAttachmentSettings(Consumer<JobAttachmentSettings.Builder> jobAttachmentSettings) {
            return this.jobAttachmentSettings((JobAttachmentSettings)((JobAttachmentSettings.Builder)JobAttachmentSettings.builder().applyMutation(jobAttachmentSettings)).build());
        }

        public Builder jobRunAsUser(JobRunAsUser var1);

        default public Builder jobRunAsUser(Consumer<JobRunAsUser.Builder> jobRunAsUser) {
            return this.jobRunAsUser((JobRunAsUser)((JobRunAsUser.Builder)JobRunAsUser.builder().applyMutation(jobRunAsUser)).build());
        }

        public Builder logGroupName(String var1);

        public Builder queueRoleArn(String var1);

        public Builder parameters(Map<String, JobParameter> var1);

        public Builder schemaVersion(String var1);

        public Builder pathMappingRules(Collection<PathMappingRule> var1);

        public Builder pathMappingRules(PathMappingRule ... var1);

        public Builder pathMappingRules(Consumer<PathMappingRule.Builder> ... var1);
    }
}

